(defproject com.signal-ai/logging-timbre "0.4.0"
  :description "Consistent timbre configuration, with JSON structured logging support"
  :url "http://github.com/signal-ai/signal-logging-timbre"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :dependencies [[com.taoensso/timbre "6.6.1"]

                 [viesti/timbre-json-appender "0.2.14"]

                 ;; route other logging through slf4j -> timbre
                 [com.taoensso/timbre-slf4j "6.6.1"]

                 [org.slf4j/slf4j-api "2.0.16"]
                 [org.slf4j/jul-to-slf4j "2.0.16"]
                 [org.slf4j/jcl-over-slf4j "2.0.16"]
                 [org.slf4j/log4j-over-slf4j "2.0.16"]
                 [org.slf4j/osgi-over-slf4j "2.0.16"]]
  :exclusions
  [;; Exclude transitive dependencies on all other logging
   ;; implementations, including other SLF4J bridges.
   commons-logging
   log4j
   org.apache.logging.log4j/log4j
   ch.qos.logback/logback-classic
   ch.qos.logback/logback-core
   org.slf4j/simple
   org.slf4j/slf4j-jcl
   org.slf4j/slf4j-nop
   org.slf4j/slf4j-log4j12
   org.slf4j/slf4j-log4j13]

  :profiles {:test {:dependencies [[lambdaisland/kaocha "1.91.1392"]
                                   [lambdaisland/kaocha-junit-xml "1.17.101"]
                                   [lambdaisland/kaocha-cloverage "1.1.89"]

                                   [metosin/jsonista "0.3.13"]

                                   ;; http
                                   [compojure "1.7.1"]
                                   [ring/ring-defaults "0.5.0"]
                                   [ring/ring-mock "0.4.0"]]}}

  :deploy-repositories [["releases" {:url "https://clojars.org/repo"
                                     :username :env/clojars_username
                                     :password :env/clojars_token
                                     :sign-releases false}]
                        ["snapshots" {:url "https://clojars.org/repo"
                                      :username :env/clojars_username
                                      :password :env/clojars_token}]]
  :aliases {"test" ["with-profile" "dev,test" "run" "-m" "kaocha.runner"]})
