# pipelines-chemas

[malli](https://github.com/metosin/malli) based schemas for the data-pipeline platform, see the [source of schema definitions](https://signal-ai.getoutline.com/doc/data-platform-services-output-AEOi7Z8RY7).

## Usage

[![Clojars Project](https://img.shields.io/clojars/v/com.signal-ai/pipeline-schemas.svg)](https://clojars.org/com.signal-ai/pipeline-schemas)

Include this libary in your project.clj

```project.clj
[com.signal-ai/pipeline-schemas "0.1.0"]
```

```clj
(require '[signal.pipeline_schemas.messages :as message-schemas])
(require '[malli.core :as m])
(require '[malli.error :refer [humanize]])

;; to validate a V2 message with the :story-info data label and return a human readable output on error
(def validate-v2-message (comp humanize (m/explainer (message-schemas/v2 [:story-info]))))

(validate-v2-message {:version 2
                      :id "7309cec5-5a34-45a7-ab30-2daf7ebebb52_50"
                      :data {:story-info {:key "7309cec5-5a34-45a7-ab30-2daf7ebebb52_50"
                                          :bucket "prod.pipeline.story-info.out.signal"}}})
;; nil
(validate-v2-message {:version 2
                      :id "7309cec5-5a34-45a7-ab30-2daf7ebebb52_50"
                      :data {:wrong-data-label {:key "7309cec5-5a34-45a7-ab30-2daf7ebebb52_50"
                                          :bucket "prod.pipeline.story-info.out.signal"}}})
;; {:data {:story-info ["missing required key"] :wrong-data-label ["disallowed key"]}
```

## License

Copyright © 2021 Signal AI

This program and the accompanying materials are made available under the
terms of the Eclipse Public License 2.0 which is available at
http://www.eclipse.org/legal/epl-2.0.

This Source Code may also be made available under the following Secondary
Licenses when the conditions for such availability set forth in the Eclipse
Public License, v. 2.0 are satisfied: GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or (at your
option) any later version, with the GNU Classpath Exception which is available
at https://www.gnu.org/software/classpath/license.html.
