(ns signal.pipeline_schemas.data
  (:require [malli.util :as mu]))

(defn payload
  "Returns a base schema for a generic pipeline payload"
  []
  [:map
   ;; TODO: correctly validate uuids (strings or uuids?)
   [:id string?]
   ;; TODO: correctly validate dates
   [:published string?]
   [:content string?]])


(defn article-payload
  "Returns a schema for an article-pipeline payload."
  []
  (mu/merge
   (payload)
   [:map
    [:author [:or string? nil?]]
    [:language string?]
    ;; TODO: validate URL
    [:original-url string?]
    [:source string?]
    [:title string?]
    [:canonical-source-name string?]
    [:content-licensor string?]
    ;; TODO: should be a list of uuids
    [:duplicate-source-ids [:sequential string?]]
    [:feed string?]
    [:licence-id string?]
    [:media-type string?]
    ;; TODO: should be a uuid
    [:original-id string?]
    ;; TODO: should be a uuid
    [:original-source-id string?]
    [:realtime boolean?]
    ;; TODO: correctly validate dates
    [:received string?]
    [:should-translate boolean?]
    [:signal-importance int?]
    [:source-groups [:sequential any?]]
    [:source-location [:map
                       [:country string?]
                       [:region string?]
                       [:subregion string?]]]

    ;; TODO: should be a uuid
    [:canonical-source {:optional true} string?]
    [:canonical-source-reach {:optional true} [:map
                                               ;; TODO: should be a uuid
                                               [:source-id string?]
                                               [:value int?]
                                               [:reach-origin any?]
                                               [:reach-provider string?]
                                               [:type string?]]]]))

(comment
  (article-payload))
