(ns com.sixsq.nuvla.server.resources.credential-swarm-token
  "
A token generated by a Docker Swarm that is required for a machine to become
either a manager or worker within the Swarm.
"
  (:require
    [com.sixsq.nuvla.auth.acl-resource :as a]
    [com.sixsq.nuvla.server.resources.common.utils :as u]
    [com.sixsq.nuvla.server.resources.credential :as p]
    [com.sixsq.nuvla.server.resources.credential-template-swarm-token :as tpl-swarm-token]
    [com.sixsq.nuvla.server.resources.resource-metadata :as md]
    [com.sixsq.nuvla.server.resources.spec.credential-swarm-token :as swarm-token-spec]
    [com.sixsq.nuvla.server.resources.spec.credential-template-swarm-token :as ct-swarm-token-spec]
    [com.sixsq.nuvla.server.util.metadata :as gen-md]))


;;
;; initialization
;;

(def resource-metadata (gen-md/generate-metadata ::ns ::p/ns ::swarm-token-spec/schema))


(defn initialize
  []
  (md/register resource-metadata))


;;
;; convert template to credential
;;

(defmethod p/tpl->credential tpl-swarm-token/credential-subtype
  [{:keys [subtype method scope token parent acl]} _request]
  [nil (cond-> {:resource-type p/resource-type
                :subtype       subtype
                :method        method
                :scope         scope
                :token         token}
               acl (assoc :acl acl)
               parent (assoc :parent parent))])


;;
;; multimethods for validation
;;

(def validate-fn (u/create-spec-validation-fn ::swarm-token-spec/schema))


(defmethod p/validate-subtype tpl-swarm-token/credential-subtype
  [resource]
  (validate-fn resource))


(def create-validate-fn (u/create-spec-validation-fn ::ct-swarm-token-spec/schema-create))


(defmethod p/create-validate-subtype tpl-swarm-token/credential-subtype
  [resource]
  (create-validate-fn resource))


;;
;; operations
;;

(defn set-collection-ops
  [{:keys [id] :as resource} request]
  (if (a/can-add? resource request)
    (assoc resource :operations [(u/operation-map id :add)])
    (dissoc resource :operations)))


(defn set-resource-ops
  [{:keys [id] :as resource} request]
  (let [ops (cond-> []
                    (a/can-edit? resource request) (conj (u/operation-map id :edit))
                    (a/can-delete? resource request) (conj (u/operation-map id :delete)))]
    (if (seq ops)
      (assoc resource :operations ops)
      (dissoc resource :operations))))


(defmethod p/set-credential-operations tpl-swarm-token/credential-subtype
  [{:keys [resource-type] :as resource} request]
  (if (u/is-collection? resource-type)
    (set-collection-ops resource request)
    (set-resource-ops resource request)))
