(ns com.sixsq.nuvla.server.resources.spec.vulnerability
  (:require
    [clojure.spec.alpha :as s]
    [com.sixsq.nuvla.server.resources.spec.common :as common]
    [com.sixsq.nuvla.server.resources.spec.core :as core]
    [com.sixsq.nuvla.server.util.spec :as su]
    [spec-tools.core :as st]))

(s/def ::reference
  (-> (st/spec ::core/nonblank-string)
      (assoc :name "reference"
             :json-schema/type "string"

             :json-schema/description "reference to the official vulnerability page"
             :json-schema/group "body"
             :json-schema/order 18)))

(s/def ::published
  (-> (st/spec ::core/nonblank-string)
      (assoc :name "published"
             :json-schema/display-name "publish date"
             :json-schema/description "date when the vulnerability was officially published"

             :json-schema/group "body"
             :json-schema/order 19)))

(s/def ::modified
  (-> (st/spec ::core/nonblank-string)
      (assoc :name "modified"
             :json-schema/display-name "modified date"
             :json-schema/description "date when the vulnerability was officially modified"

             :json-schema/group "body"
             :json-schema/order 20)))

(s/def ::score
  (-> (st/spec (s/and number? #(not (neg? %))))
      (assoc :name "score"

             :json-schema/description "base score of the vulnerability"
             :json-schema/group "body"
             :json-schema/order 21)))

(s/def ::severity
  (-> (st/spec #{"NONE" "LOW" "MEDIUM" "HIGH" "CRITICAL"})
      (assoc :name "severity"
             :json-schema/type "string"
             :json-schema/value-scope {:values ["NONE" "LOW" "MEDIUM" "HIGH" "CRITICAL"]}

             :json-schema/description "severity of the vulnerability"
             :json-schema/group "body"
             :json-schema/order 22)))

(s/def ::schema
  (su/only-keys-maps common/common-attrs
                     {:opt-un [::reference
                               ::published
                               ::modified
                               ::score
                               ::severity]}))