(ns com.sixsq.nuvla.server.resources.credential-template-swarm-token
  "
This resource allows a token generated by a Docker Swarm to be stored as a
`credential`. A token allows a (virtual) machine to become either a manager or
worker within the Swarm.
"
  (:require
    [com.sixsq.nuvla.auth.utils.acl :as acl-utils]
    [com.sixsq.nuvla.server.resources.common.utils :as u]
    [com.sixsq.nuvla.server.resources.credential-template :as p]
    [com.sixsq.nuvla.server.resources.resource-metadata :as md]
    [com.sixsq.nuvla.server.resources.spec.credential-template-swarm-token :as swarm-token]
    [com.sixsq.nuvla.server.util.metadata :as gen-md]))


(def ^:const credential-subtype "swarm-token")


(def ^:const resource-url credential-subtype)


(def ^:const method "swarm-token")


(def resource-acl (acl-utils/normalize-acl {:owners   ["group/nuvla-admin"]
                                            :view-acl ["group/nuvla-user"]}))

;;
;; resource
;;

(def ^:const template
  {:subtype           credential-subtype
   :method            method
   :name              "Swarm Token"
   :description       "stores a Swarm token for master or worker"
   :acl               resource-acl
   :resource-metadata "resource-metadata/credential-template-swarm-token"})


;;
;; initialization: register this credential-template
;;

(def resource-metadata (gen-md/generate-metadata ::ns ::p/ns ::swarm-token/schema))


(def resource-metadata-create (gen-md/generate-metadata ::ns ::p/ns ::swarm-token/schema-create "create"))


(defn initialize
  []
  (p/register template)
  (md/register resource-metadata)
  (md/register resource-metadata-create))


;;
;; multimethods for validation
;;

(def validate-fn (u/create-spec-validation-fn ::swarm-token/schema))


(defmethod p/validate-subtype method
  [resource]
  (validate-fn resource))


