(ns com.sixsq.nuvla.pricing.protocol)


(defprotocol Pricing
  (set-api-key! [this api-key])
  (get-api-key [this])
  (create-customer [this params])
  (retrieve-customer [this customer-id])
  (update-customer [this customer params])
  (delete-customer [this customer])
  (delete-discount [this obj])
  (get-customer-subscriptions [this customer])
  (list-subscriptions [this params])
  (create-subscription [this params])
  (list-products [this products])
  (list-prices [this params])
  (retrieve-subscription [this subscription-id])
  (cancel-subscription [this subscription params])
  (collection-iterator [this collection])
  (create-setup-intent [this params])
  (list-invoices [this params])
  (retrieve-payment-method [this payment-method-id])
  (detach-payment-method [this payment-method])
  (oauth-token [this params])
  (login-link-create-on-account [this account-id])
  (create-price [this params])
  (retrieve-price [this price-id])
  (get-id [this obj])
  (get-deleted [this obj])
  (get-status [this obj])
  (get-start-date [this obj])
  (get-current-period-end [this obj])
  (get-current-period-start [this obj])
  (get-trial-start [this obj])
  (get-trial-end [this obj])
  (get-metadata [this obj])
  (get-name [this obj])
  (get-active [this obj])
  (get-currency [this obj])
  (get-interval [this obj])
  (get-usage-type [this obj])
  (get-billing-scheme [this obj])
  (get-trial-period-days [this obj])
  (get-amount [this obj])
  (get-recurring [this obj])
  (get-aggregate-usage [this obj])
  (get-tiers-mode [this obj])
  (get-tiers [this obj])
  (get-unit-amount [this obj])
  (get-up-to [this obj])
  (get-client-secret [this obj])
  (get-card [this obj])
  (get-sepa-debit [this obj])
  (get-brand [this obj])
  (get-last4 [this obj])
  (get-exp-month [this obj])
  (get-exp-year [this obj])
  (get-invoice-settings [this obj])
  (get-default-payment-method [this obj])
  (get-lines [this obj])
  (get-description [this obj])
  (get-quantity [this obj])
  (get-period [this obj])
  (get-start [this obj])
  (get-end [this obj])
  (get-created [this obj])
  (get-due-date [this obj])
  (get-invoice-pdf [this obj])
  (get-paid [this obj])
  (get-total [this obj])
  (get-subtotal [this obj])
  (get-data [this obj])
  (get-number [this obj])
  (get-address [this obj])
  (get-city [this obj])
  (get-country [this obj])
  (get-line1 [this obj])
  (get-postal-code [this obj])
  (get-discount [this obj])
  (get-coupon [this obj])
  (get-amount-off [this obj])
  (get-duration [this obj])
  (get-duration-in-months [this obj])
  (get-percent-off [this obj])
  (get-valid [this obj])
  (get-user-id [this obj])
  (get-url [this obj])
  (get-product [this obj])
  (coupon->map [this coupon])
  (customer->map [this customer])
  (subscription->map [this subscription])
  (payment-method-card->map [this payment-method])
  (payment-method-sepa->map [this payment-method])
  (setup-intent->map [this setup-intent])
  (invoice-line-item->map [this invoice-line-item])
  (invoice->map [this invoice extend])
  (price->map [this price])
  (get-default-payment-method-customer [this customer])
  (list-payment-methods [this params])
  (list-payment-methods-customer [this customer])
  (get-upcoming-invoice [this params])
  (get-upcoming-invoice-subscription-id [this subscription-id])
  (price->unit-float [this price]))
