package com.socialquantum.battleship.gameapi.internal.dataobjects.startgame;

import com.socialquantum.battleship.gameapi.types.base.ExecutionStatus;
import com.socialquantum.battleship.gameapi.types.response.StartGame;

/**
 * // {
 * //     "status": "OK",
 * //     "data": {
 * //         "message": "Game 37812032-d0fe-42bc-a264-fd271e629c3c started successfully"
 * //     }
 * // }
 * Created 30/06/17 13:44
 *
 * @author Vladimir Bogodukhov
 **/
public class StartGameResponseData implements StartGame {

    private static class Data {
        String message;

        @Override
        public String toString() {
            return "Data(message='" + message + ")";
        }
    }

    private ExecutionStatus status;

    private final Data data = new Data();


    public ExecutionStatus status() {
        return status;
    }

    public String message() {
        return data.message;
    }

    public StartGameResponseData setMessage(String message) {
        data.message = message;
        return this;
    }

    public StartGameResponseData setStatus(ExecutionStatus status) {
        this.status = status;
        return this;
    }

    @Override
    public String toString() {
        return "StartGameResponseData status=" + status + ", data=" + data + ")";
    }
}
