/*
 * Decompiled with CFR 0.152.
 */
package com.socialquantum.battleship.gameapi.internal.serializationutils;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus.GameStateDataStatus;
import java.lang.reflect.Type;
import java.util.Objects;

public class SerializationDeserializationFactory {
    private static final GsonBuilder GSON_BUILDER = SerializationDeserializationFactory.configBuilder();

    public <T> T loadObject(String data, Class<T> clazz) {
        return (T)GSON_BUILDER.create().fromJson(data, clazz);
    }

    public String saveObject(Object dataObject) {
        Objects.requireNonNull(dataObject);
        return GSON_BUILDER.create().toJson(dataObject);
    }

    private static GsonBuilder configBuilder() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(GameStateDataStatus.class, (Object)new GameStateDataStatusDeserializer());
        return gsonBuilder;
    }

    private static class GameStateDataStatusDeserializer
    implements JsonSerializer<GameStateDataStatus>,
    JsonDeserializer<GameStateDataStatus> {
        private GameStateDataStatusDeserializer() {
        }

        public JsonElement serialize(GameStateDataStatus src, Type typeOfSrc, JsonSerializationContext context) {
            if (src == null) {
                return null;
            }
            return new JsonPrimitive(src.ident());
        }

        public GameStateDataStatus deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return GameStateDataStatus.elementByName(json.getAsString());
        }
    }
}

