package com.socialquantum.battleship.gameapi.internal.dataobjects.gamelist;

import com.socialquantum.battleship.gameapi.internal.dataobjects.defaultresponse.DefaultResponseData;
import com.socialquantum.battleship.gameapi.types.base.GameId;
import com.socialquantum.battleship.gameapi.types.response.GameList;
import com.socialquantum.battleship.gameapi.types.base.ExecutionStatus;
import com.socialquantum.battleship.gameapi.utils.TransformUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * //{
 * //    "status" : "OK",
 * //    "data" : {
 * //        "game_ids" : ["7234cf67-8b42-4580-902c-f83ddcaed309", "f8ba64b9-c233-4f7f-8550-ca3c2a9193b3" ]
 * //    }
 * //}
 * Created 29/06/17 15:47
 *
 * @author Vladimir Bogodukhov
 **/
public class GameListResponseData implements GameList {


    private ExecutionStatus status;
    private final DefaultResponseData data = new DefaultResponseData();

    @Override
    public ExecutionStatus status() {
        return status;
    }

    @Override
    public List<GameId> gameIds() {
        return data.game_ids.stream().map(TransformUtils::gameId).collect(Collectors.toList());
    }

    public GameListResponseData addIdAsString(String s) {
        data.game_ids.add(s);
        return this;
    }

    public GameListResponseData setStatus(ExecutionStatus status) {
        this.status = status;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof GameListResponseData)) return false;

        GameListResponseData that = (GameListResponseData) o;

        if (status != that.status) return false;
        return data.equals(that.data);
    }

    @Override
    public int hashCode() {
        int result = status != null ? status.hashCode() : 0;
        result = 31 * result + data.hashCode();
        return result;
    }
}
