package com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus;

import com.socialquantum.battleship.gameapi.types.base.BattleField;
import com.socialquantum.battleship.gameapi.types.base.Cell;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

/**
 * Created 05/07/17 16:15
 *
 * @author Vladimir Bogodukhov
 **/
public class DefaultField implements BattleField {

    public final List<List<DefaultCell>> cells = new ArrayList<>();

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DefaultField)) return false;

        DefaultField field = (DefaultField) o;

        return cells.equals(field.cells);
    }

    public void rows(Consumer<DefaultCell[]> consumer) {
        cells.forEach(cells -> consumer.accept(cells.toArray(new DefaultCell[cells.size()])));
    }

    public Cell cell(int x, int y) {
        checkIntBounds(0, 9, x);
        checkIntBounds(0, 9, y);
        return cells.get(y).get(x);
    }

    @Override
    public int hashCode() {
        return cells.hashCode();
    }

    /**
     * Проверить что значение в интервале - и бросить искобчение
     *
     * @param from  начало интервала - включительно
     * @param to    окончание интервала - включительно
     * @param value значение
     */
    public static void checkIntBounds(int from, int to, int value) {
        if (!(from <= value && value <= to)) throw new IllegalArgumentException("value " + value +
                " is not in bounds [" + from + ", " + to + "]");
    }

}
