package com.socialquantum.battleship.gameapi.internal.dataobjects.move;

import com.socialquantum.battleship.gameapi.types.base.GameId;

/**
 * https://paste.sqtools.ru/j/ygvx7
 * //{
 * //    "command": "move",
 * //    "params": {
 * //        “game_id”: “37812032-d0fe-42bc-a264-fd271e629c3c”,
 * //        “type”: “shoot”,
 * //         "x": 1,
 * //         "y": 2
 * //    }
 * //}
 * Created 30/06/17 18:08
 * @author Vladimir Bogodukhov
 **/
public class ShootRequestData {

    public static final String MOVE_COMMAND_NAME = "move";
    public static final String SHOOT_SUBTYPE = "shoot";

    private static class Params {
        private String game_id;
        private final String type = SHOOT_SUBTYPE;
        private int x;
        private int y;
    }

    private final String command = MOVE_COMMAND_NAME;
    private final Params params = new Params();

    public int x() {
        return params.x;
    }

    public ShootRequestData setX(int x) {
        this.params.x = x;
        return this;
    }

    public int y() {
        return params.y;
    }

    public ShootRequestData setY(int y) {
        params.y = y;
        return this;
    }

    public ShootRequestData setCoords(int x, int y) {
        params.x = x;
        params.y = y;
        return this;
    }

    public ShootRequestData setGameId(GameId gameId) {
        params.game_id = gameId.value();
        return this;
    }


}
