package com.socialquantum.battleship.gameapi.types.base;

import java.util.Arrays;

/**
 * Статус клетки поля.
 * Created 05/07/17 14:40
 *
 * @author Vladimir Bogodukhov
 *         {@link com.socialquantum.battleship.gameapi.types.base.CellStatus}
 **/
public enum CellStatus {

    /**
     * пустая клетка
     */
    empty,

    /**
     * в клетке располагается корабль
     */
    ship,

    /**
     * в клетке располагается подбитая часть корабля
     */
    hit,

    /**
     * по клетке был совершен выстрел, но корабля в ней не оказалось
     */
    miss;


    /**
     * Проверить что данный статус принадлежит множеству статусов.
     *
     * @param statuses множество статусов.
     * @return -
     */
    public boolean in(CellStatus... statuses) {
        return Arrays.stream(statuses).anyMatch(cellStatus -> cellStatus == CellStatus.this);
    }


}
