/*
 * Decompiled with CFR 0.152.
 */
package com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus;

import com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus.DefaultCell;
import com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus.DefaultField;
import com.socialquantum.battleship.gameapi.types.base.Asset;
import com.socialquantum.battleship.gameapi.types.base.Cell;
import com.socialquantum.battleship.gameapi.types.base.CellStatus;
import com.socialquantum.battleship.gameapi.types.base.UserToken;
import com.socialquantum.battleship.gameapi.utils.TransformUtils;
import java.util.function.Consumer;

public class PlayerAsset
implements Asset {
    private String user;
    private final DefaultField field = new DefaultField();

    @Override
    public CellStatus cellStatus(int x, int y) {
        return this.field.cells.get((int)y).get((int)x).content.value;
    }

    @Override
    public UserToken userToken() {
        return TransformUtils.userToken(this.user);
    }

    @Override
    public void rows(Consumer<Cell[]> consumer) {
        this.field.cells.forEach(cells -> consumer.accept(cells.toArray(new DefaultCell[cells.size()])));
    }

    public DefaultField field() {
        return this.field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlayerAsset)) {
            return false;
        }
        PlayerAsset asset = (PlayerAsset)o;
        if (this.user != null ? !this.user.equals(asset.user) : asset.user != null) {
            return false;
        }
        return this.field.equals(asset.field);
    }

    public int hashCode() {
        int result = this.user != null ? this.user.hashCode() : 0;
        result = 31 * result + this.field.hashCode();
        return result;
    }
}

