package com.socialquantum.battleship.gameapi.internal.dataobjects.creategame;

import com.socialquantum.battleship.gameapi.types.base.GameId;
import com.socialquantum.battleship.gameapi.types.response.CreateGame;
import com.socialquantum.battleship.gameapi.types.base.ExecutionStatus;

/**
 * // {
 * //     "status": "OK"
 * //     "data": {
 * //         "game_id": "3f888e99-5f6b-498d-80cb-dd45787421b1"
 * //     }
 * // }
 * Created 27/06/17 16:47
 *
 * @author Vladimir Bogodukhov
 **/
public class CreateGameResponseData implements CreateGame {

    public static class Data {
        private GameId game_id;

        @Override
        public String toString() {
            return "Data(" + "game_id='" + game_id + ")";
        }
    }

    private ExecutionStatus status;
    private final Data data = new Data();

    @Override
    public GameId gameId() {
        return this.data.game_id;
    }

    @Override
    public ExecutionStatus status() {
        return status;
    }

    @Override
    public String toString() {
        return "CreateGameResponseData(" + "status=" + status + ", data=" + data + ')';
    }
}
