package com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus;

import com.socialquantum.battleship.gameapi.types.base.Cell;
import com.socialquantum.battleship.gameapi.types.base.CellContent;
import com.socialquantum.battleship.gameapi.types.base.CellStatus;

/**
 * Created 05/07/17 16:10
 *
 * @author Vladimir Bogodukhov
 **/

public class DefaultCell implements Cell {
    public static class DefaultContent implements CellContent {
        public CellStatus value;
        public CellStatus status() {
            return value;
        }
    }

    public final DefaultContent content = new DefaultContent();

    @Override
    public DefaultContent content() {
        return content;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DefaultCell)) return false;

        DefaultCell cell = (DefaultCell) o;

        return content.equals(cell.content);
    }

    @Override
    public int hashCode() {
        return content.hashCode();
    }
}

