package com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus;

import com.socialquantum.battleship.gameapi.types.base.Asset;
import com.socialquantum.battleship.gameapi.types.base.Cell;
import com.socialquantum.battleship.gameapi.types.base.CellStatus;
import com.socialquantum.battleship.gameapi.types.base.UserToken;

import java.util.function.Consumer;

/**
 * Created 11/07/17 09:10
 *
 * @author Vladimir Bogodukhov 
 **/
public class PlayerAsset implements Asset {
    private UserToken user;
    private final DefaultField field = new DefaultField();

    public CellStatus cellStatus(int x, int y) {
        return field.cells.get(y).get(x).content.value;
    }

    @Override
    public UserToken userToken() {
        return user;
    }

    @Override
    public void rows(Consumer<Cell[]> consumer) {
        field.cells.forEach(cells -> consumer.accept(cells.toArray(new DefaultCell[cells.size()])));
    }

    public DefaultField field() {
        return field;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PlayerAsset)) return false;

        PlayerAsset asset = (PlayerAsset) o;

        if (user != null ? !user.equals(asset.user) : asset.user != null) return false;
        return field.equals(asset.field);
    }

    @Override
    public int hashCode() {
        int result = user != null ? user.hashCode() : 0;
        result = 31 * result + field.hashCode();
        return result;
    }
}

