package com.socialquantum.battleship.gameapi.types.request.placeships;

import com.socialquantum.battleship.gameapi.types.base.ShipOrientation;
import com.socialquantum.battleship.gameapi.internal.dataobjects.placeships.PlaceShipsRequestData;
import com.socialquantum.battleship.gameapi.types.base.ShipType;
import com.socialquantum.battleship.gameapi.types.base.GameId;

/**
 *
 *
 * Вспомогательный объект расстановки кораблей.
 * Created 10/07/17 13:49
 * @author Vladimir Bogodukhov
 * {@link com.socialquantum.battleship.gameapi.types.request.placeships.ShipsPlacementRequest}
 **/
public interface ShipsPlacementRequest {

    /**
     * Установка идентификатора игры.
     *
     * @param gameId идентификатора игры всегда не null
     * @return ссылка на объект, в котором производится установка
     */
    ShipsPlacementRequest setGameId(GameId gameId);

    /**
     * Добавить информацию о расстановке кораблей.
     *
     * @param type        тип корабля.
     * @param orientation оприентация
     * @param x           координата x
     * @param y           координата y
     * @return ссылка на объект, в котором производится установка
     */
    ShipsPlacementRequest addShip(ShipType type, ShipOrientation orientation, int x, int y);

    /**
     *
     * Фабричный метод получения нового объекта.
     *
     * @return новый объект расстановки кораблей.
     */
    static ShipsPlacementRequest createRequest() {
        return new PlaceShipsRequestData();
    }
}
