package com.socialquantum.battleship.gameapi.internal.dataobjects.deletesnapshot;

import com.socialquantum.battleship.gameapi.types.base.SnapshotId;

/**
 * // {
 * //     "command" : "delete_snapshot",
 * //     "params" : {
 * //         "snapshot_id" : "f2eb0f14-86de-4ccb-8f89-f47cf3407485"
 * //     }
 * // }
 * Created 07/07/17 07:49
 *
 * @author Vladimir Bogodukhov
 **/
public class DeleteSnapshotRequestData {

    private static final String DELETE_SNAPSHOT_COMMAND_NAME = "delete_snapshot";

    private static class Params {
        private SnapshotId snapshot_id;
    }

    private String command = DELETE_SNAPSHOT_COMMAND_NAME;
    private final Params params = new Params();

    public DeleteSnapshotRequestData setSnapshotId(SnapshotId snapshotId) {
        params.snapshot_id = snapshotId;
        return this;
    }

    public SnapshotId snapshotId() {
        return params.snapshot_id;
    }
}
