package com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus;

import com.socialquantum.battleship.gameapi.types.base.*;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

/**
 * Created 11/07/17 09:10
 *
 * @author Vladimir Bogodukhov
 **/
public class PlayerAsset implements Asset {
    private UserToken user;
    private final DefaultField field = new DefaultField();
    private Iterable<CellEntry> cellEntries = new Iterable<CellEntry>() {
        @Override
        public Iterator<CellEntry> iterator() {
            return new Iterator<CellEntry>() {
                int x = 0;
                int y = 0;

                @Override
                public boolean hasNext() {
                    return x <= 9 || y <= 9;
                }

                @Override
                public CellEntry next() {
                    if (!hasNext()) throw new NoSuchElementException();
                    Cell cell = field.cells.get(y).get(x);


                    CellEntry cellEntry = new CellEntry() {
                        private int xx;
                        private int yy;

                        {
                            this.xx = x;
                            this.yy = y;
                        }

                        @Override
                        public int x() {
                            return xx;
                        }

                        @Override
                        public int y() {
                            return yy;
                        }

                        @Override
                        public Cell cell() {
                            return cell;
                        }
                    };

                    if (x == 9 && y ==9) {
                        x++;
                        y++;
                    } else if (x < 9) {
                        x++;
                    } else if (y < 9) {
                        x = 0;
                        y++;
                    }

                    return cellEntry;
                }


            };
        }
    };

    public CellStatus cellStatus(int x, int y) {
        return field.cells.get(y).get(x).content.value;
    }

    @Override
    public Iterable<CellEntry> cells() {
        return cellEntries;
    }

    @Override
    public Stream<CellEntry> cellsStream() {
        return StreamSupport.stream(new CellEntrySpliterator(cells().iterator()), false);
    }

    @Override
    public UserToken userToken() {
        return user;
    }

    @Override
    public void rows(Consumer<Cell[]> consumer) {
        field.cells.forEach(cells -> consumer.accept(cells.toArray(new DefaultCell[cells.size()])));
    }

    public DefaultField field() {
        return field;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PlayerAsset)) return false;

        PlayerAsset asset = (PlayerAsset) o;

        if (user != null ? !user.equals(asset.user) : asset.user != null) return false;
        return field.equals(asset.field);
    }

    @Override
    public int hashCode() {
        int result = user != null ? user.hashCode() : 0;
        result = 31 * result + field.hashCode();
        return result;
    }
}

