package com.socialquantum.battleship.gameapi.types.response;

import com.socialquantum.battleship.gameapi.types.base.Asset;
import com.socialquantum.battleship.gameapi.types.base.UserToken;

import java.util.List;

/**
 * Результат выполнения команды получения текущего статуса игры.
 * Created 28/06/17 14:27
 *
 * @author Vladimir Bogodukhov
 *         {@link com.socialquantum.battleship.gameapi.types.response.GameStatus}
 **/
public interface GameStatus extends OperationResponse {

    /**
     * @return порядок следования игроков (не null объект с не null элементами)
     */
    List<UserToken> usersOrder();

    /**
     * @return Идентификатор  пользователя, который в данный момент осуществляет ход.
     */
    UserToken currentTurnUserToken();

    /**
     * @return Номер хода от начала игры.
     */
    int turnNumber();


    /**
     * @param playerToken токен игрока.
     * @return свойства игрока в игре
     */
    Asset asset(UserToken playerToken);





}
