/*
 * Decompiled with CFR 0.152.
 */
package com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus;

import com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus.CellEntrySpliterator;
import com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus.DefaultCell;
import com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus.DefaultField;
import com.socialquantum.battleship.gameapi.types.base.Asset;
import com.socialquantum.battleship.gameapi.types.base.Cell;
import com.socialquantum.battleship.gameapi.types.base.CellEntry;
import com.socialquantum.battleship.gameapi.types.base.CellStatus;
import com.socialquantum.battleship.gameapi.types.base.UserToken;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PlayerAsset
implements Asset {
    private UserToken user;
    private final DefaultField field = new DefaultField();
    private Iterable<CellEntry> cellEntries = new Iterable<CellEntry>(){

        @Override
        public Iterator<CellEntry> iterator() {
            return new Iterator<CellEntry>(){
                int x = 0;
                int y = 0;

                @Override
                public boolean hasNext() {
                    return this.x <= 9 || this.y <= 9;
                }

                @Override
                public CellEntry next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    final Cell cell = ((PlayerAsset)PlayerAsset.this).field.cells.get(this.y).get(this.x);
                    CellEntry cellEntry = new CellEntry(){
                        private int xx;
                        private int yy;
                        {
                            this.xx = x;
                            this.yy = y;
                        }

                        @Override
                        public int x() {
                            return this.xx;
                        }

                        @Override
                        public int y() {
                            return this.yy;
                        }

                        @Override
                        public Cell cell() {
                            return cell;
                        }
                    };
                    if (this.x == 9 && this.y == 9) {
                        ++this.x;
                        ++this.y;
                    } else if (this.x < 9) {
                        ++this.x;
                    } else if (this.y < 9) {
                        this.x = 0;
                        ++this.y;
                    }
                    return cellEntry;
                }
            };
        }
    };

    @Override
    public CellStatus cellStatus(int x, int y) {
        return this.field.cells.get((int)y).get((int)x).content.value;
    }

    @Override
    public Iterable<CellEntry> cells() {
        return this.cellEntries;
    }

    @Override
    public Stream<CellEntry> cellsStream() {
        return StreamSupport.stream(new CellEntrySpliterator(this.cells().iterator()), false);
    }

    @Override
    public UserToken userToken() {
        return this.user;
    }

    @Override
    public void rows(Consumer<Cell[]> consumer) {
        this.field.cells.forEach(cells -> consumer.accept(cells.toArray(new DefaultCell[cells.size()])));
    }

    public DefaultField field() {
        return this.field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlayerAsset)) {
            return false;
        }
        PlayerAsset asset = (PlayerAsset)o;
        if (this.user != null ? !this.user.equals(asset.user) : asset.user != null) {
            return false;
        }
        return this.field.equals(asset.field);
    }

    public int hashCode() {
        int result = this.user != null ? this.user.hashCode() : 0;
        result = 31 * result + this.field.hashCode();
        return result;
    }
}

