package com.socialquantum.battleship.gameapi.internal.dataobjects.creategame;

import com.socialquantum.battleship.gameapi.types.base.UserToken;

import java.util.ArrayList;
import java.util.List;

/**
 * // {
 * //     "command":  "create_game"
 * //     "params": {
 * //         "users": ["user_id_1", "user_id_2"]
 * //     }
 * // }
 * Отправка данных к серверу - обратной сериализации не предполагается.
 * Created 29/06/17 09:05
 *
 * @author Vladimir Bogodukhov
 **/
public class CreateGameRequestData {
    private final class Params {
        private final List<String> users = new ArrayList<>();
    }

    public static final String COMMAND_NAME_VALUE = "create";

    private final String command = COMMAND_NAME_VALUE;

    private final Params params = new Params();

    /**
     * Назначить пользователей
     *
     * @param user1 -
     * @param user2 -
     * @return -
     */
    public CreateGameRequestData setUsers(UserToken user1, UserToken user2) {
        params.users.clear();
        params.users.add(user1.value());
        params.users.add(user2.value());
        return this;
    }



}
