package com.socialquantum.battleship.gameapi.internal.dataobjects.gamestatus;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

/**
 * Created 05/07/17 16:15
 *
 * @author Vladimir Bogodukhov
 **/
public class Field {

    // !NB! public -> private
    public final List<List<Cell>> cells = new ArrayList<>();

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Field)) return false;

        Field field = (Field) o;

        return cells.equals(field.cells);
    }

    public void rows(Consumer<Cell[]> consumer) {
        cells.forEach(cells -> consumer.accept(cells.toArray(new Cell[cells.size()])));
    }

    @Override
    public int hashCode() {
        return cells.hashCode();
    }
}
