(ns dawdle.channel
  (:require [dawdle.web :refer :all]))

(defn do-with-channel
  [channel channels-fn groups-fn im-fn params]
   (if-let [f (case (get channel 0)
             \C channels-fn
             \G groups-fn
             \D im-fn
             )]
     (apply f params)
     (throw (IllegalArgumentException. "No method defined for the given channel type"))))

(defn channel-info [token channel params]
  (do-with-channel channel channels-info groups-info im-info [token channel params]))

(defn channel-invite [token user channel params]
  (do-with-channel channel channels-invite groups-invite nil [token user channel params]))

(defn channel-kick [token user channel params]
  (do-with-channel channel channels-kick groups-kick nil [token user channel params]))
