/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.common.utils.metodsutils;

import com.steammachine.common.utils.metodsutils.ConstructorCaller;
import com.steammachine.common.utils.metodsutils.MethodCaller;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public class MethodUtils {
    private static final String CLASS_IS_NULL = "class is null";
    private static final Map<Level, MemberInfo> METHOD_LEVEL_INFO;

    public static Level getLevel(int modifiers) {
        for (Level l : Level.values()) {
            if ((METHOD_LEVEL_INFO.get((Object)l).flags() & modifiers) == 0) continue;
            return l;
        }
        return Level.DEFAULT;
    }

    public static List<Method> findMethods(Class<?> clazz, BiFunction<Class<?>, Method, Boolean> methodSelector) {
        Objects.requireNonNull(clazz, CLASS_IS_NULL);
        Objects.requireNonNull(methodSelector, "methodFilter is null");
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                if (!methodSelector.apply(clazz, method).booleanValue()) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> methodSelector) {
        Objects.requireNonNull(methodSelector);
        return MethodUtils.findMethods(clazz, (Class<?> aClass, Method method) -> methodSelector.test((Method)method));
    }

    public static Method findMethod(Level level, Class<?> clazz, String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        boolean[] found = new boolean[]{false};
        List<Method> methods = MethodUtils.findMethods(clazz, (Method method) -> {
            if (found[0]) {
                return false;
            }
            if (!methodName.equals(method.getName())) {
                return false;
            }
            if (!MethodUtils.isAppropriateLevel(method, level)) {
                return false;
            }
            if (returnType != null && method.getReturnType() != returnType) {
                return false;
            }
            if (!MethodUtils.arraysEqual(method.getParameterTypes(), parameterTypes)) {
                return false;
            }
            found[0] = true;
            return true;
        });
        return methods.size() == 1 ? methods.get(0) : null;
    }

    public static <T> List<Constructor<T>> findConstructors(Class<T> clazz, BiFunction<Class<T>, Constructor<T>, Boolean> constructorSelector) {
        Objects.requireNonNull(clazz, CLASS_IS_NULL);
        Objects.requireNonNull(constructorSelector, "constructorFilter is null");
        ArrayList<Constructor<T>> constructors = new ArrayList<Constructor<T>>();
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!constructorSelector.apply(clazz, constructor).booleanValue()) continue;
            constructors.add(constructor);
        }
        return constructors;
    }

    public static <T> List<Constructor<T>> findConstructors(Class<T> clazz, Predicate<Constructor<T>> constructorSelector) {
        Objects.requireNonNull(constructorSelector, "constructorFilter is null");
        return MethodUtils.findConstructors(clazz, (Class<T> c, Constructor<T> constructor) -> constructorSelector.test((Constructor)constructor));
    }

    public static <T> Constructor<T> findConstructor(Level level, Class<T> clazz, Class<?> ... parameterTypes) {
        Objects.requireNonNull(clazz, CLASS_IS_NULL);
        Objects.requireNonNull(level, "level is null");
        List<Constructor<T>> constructors = MethodUtils.findConstructors(clazz, (Class<T> tClass, Constructor<T> constructor) -> MethodUtils.isAppropriateLevel(constructor, level) && MethodUtils.arraysEqual(constructor.getParameterTypes(), parameterTypes));
        return constructors.size() == 1 ? constructors.get(0) : null;
    }

    public static List<Field> findFields(Class<?> clazz, Predicate<Field> criteria) {
        Objects.requireNonNull(clazz, CLASS_IS_NULL);
        Objects.requireNonNull(criteria, "criteria is null");
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!criteria.test(field)) continue;
                fields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    private static <T> boolean arraysEqual(T[] a1, T[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null != (a2 == null)) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (Objects.equals(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isAppropriateLevel(Method method, Level level) {
        return MethodUtils.isAppropriateLevel(method.getModifiers(), level);
    }

    private static boolean isAppropriateLevel(Constructor constructor, Level level) {
        return MethodUtils.isAppropriateLevel(constructor.getModifiers(), level);
    }

    private static boolean isAppropriateLevel(int modifiers, Level level) {
        return METHOD_LEVEL_INFO.get((Object)MethodUtils.getLevel(modifiers)).level() <= METHOD_LEVEL_INFO.get((Object)level).level();
    }

    static {
        EnumMap<Level, BaseMemberInfo> methodLevelInfo = new EnumMap<Level, BaseMemberInfo>(Level.class);
        methodLevelInfo.put(Level.PRIVATE, new BaseMemberInfo(2, 40));
        methodLevelInfo.put(Level.PROTECTED, new BaseMemberInfo(4, 30));
        methodLevelInfo.put(Level.DEFAULT, new BaseMemberInfo(0, 20));
        methodLevelInfo.put(Level.PUBLIC, new BaseMemberInfo(1, 10));
        METHOD_LEVEL_INFO = Collections.unmodifiableMap(methodLevelInfo);
    }

    private static class BaseMemberInfo
    implements MemberInfo {
        private final int flags;
        private final int level;

        private BaseMemberInfo(int flags, int level) {
            this.flags = flags;
            this.level = level;
        }

        @Override
        public int flags() {
            return this.flags;
        }

        @Override
        public int level() {
            return this.level;
        }
    }

    private static interface MemberInfo {
        public int flags();

        public int level();
    }

    public static enum Level {
        PRIVATE,
        PROTECTED,
        DEFAULT,
        PUBLIC;

    }

    public static class BaseConstructorCaller<T>
    implements ConstructorCaller<T> {
        protected final Constructor constructor;

        public BaseConstructorCaller(Constructor<T> constructor) {
            if (constructor == null) {
                throw new NullPointerException("constructor is null");
            }
            this.constructor = constructor;
        }

        @Override
        public <T> T newInstance(Object ... param) {
            boolean accessible = this.constructor.isAccessible();
            if (!accessible) {
                this.constructor.setAccessible(true);
            }
            try {
                this.constructor.setAccessible(true);
                Object t = this.constructor.newInstance(param);
                return t;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() == null) {
                    throw new IllegalStateException(e);
                }
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                if (e.getTargetException() instanceof Exception) {
                    throw new RuntimeException(e.getTargetException());
                }
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.constructor.setAccessible(accessible);
            }
        }
    }

    public static class BaseMethodCaller
    implements MethodCaller {
        protected final Method method;

        public BaseMethodCaller(Method method) {
            this.method = Objects.requireNonNull(method, "method is null");
        }

        @Override
        public <T> T invoke(Object object, Object ... param) {
            boolean accessible = this.method.isAccessible();
            if (!accessible) {
                this.method.setAccessible(true);
            }
            try {
                Object object2 = this.method.invoke(object, param);
                return (T)object2;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() == null) {
                    throw new IllegalStateException(e);
                }
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                if (e.getTargetException() instanceof Exception) {
                    throw new RuntimeException(e.getTargetException());
                }
                throw new RuntimeException(e);
            }
            finally {
                this.method.setAccessible(accessible);
            }
        }
    }
}

