/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.common.utils.enumerations;

import com.steammachine.common.lazyeval.LazyEval;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EnumComparisonUtils {
    private static final String ENUMERATIONS_ARE_NOT_EQUAL = "enumerations are not equal";

    public static boolean compareEnums(Class<? extends Enum>[] enumeration) {
        if (enumeration == null) {
            throw new NullPointerException("enumeration is null");
        }
        for (Class<? extends Enum> aClass : enumeration) {
            if (aClass != null) continue;
            throw new NullPointerException("one of passed classes in null " + Arrays.asList(enumeration));
        }
        for (Class<? extends Enum> enumClass1 : enumeration) {
            for (Class<? extends Enum> enumClass2 : enumeration) {
                if (EnumComparisonUtils.compareEnumClasses(enumClass1, enumClass2, null)) continue;
                return false;
            }
        }
        return true;
    }

    public static void checkIfEnumsAreEqual(Class<? extends Enum>[] enumerations) {
        if (!EnumComparisonUtils.compareEnums(enumerations)) {
            throw new IllegalStateException("enumerations are not equal " + Arrays.toString(enumerations));
        }
    }

    @SafeVarargs
    public static void checkIfEnumsEqual(Class<? extends Enum> ... enumerations) {
        if (!EnumComparisonUtils.compareEnums(enumerations)) {
            throw new IllegalStateException("enumerations are not equal " + Arrays.toString(enumerations));
        }
    }

    public static void assertEnumElements(Enum<?> ... enums) {
        if (!EnumComparisonUtils.compareEnumElements(enums)) {
            throw new IllegalStateException("" + Arrays.toString(enums));
        }
    }

    public static <T1 extends Enum, T2 extends Enum> boolean deepIfEnumsAreEqual(Class<T1> e1, Class<T2> e2, EntityComparator<T1, T2> comparator) {
        return EnumComparisonUtils.compareEnumClasses(e1, e2, comparator);
    }

    public static <T1 extends Enum, T2 extends Enum> void deepCheckIfEnumsAreEqual(Class<T1> e1, Class<T2> e2, EntityComparator<T1, T2> comparator) {
        if (!EnumComparisonUtils.deepIfEnumsAreEqual(e1, e2, comparator)) {
            throw new IllegalStateException();
        }
    }

    public static boolean compareEnumElements(Enum<?> ... enums) {
        if (enums == null) {
            throw new NullPointerException("enums is null");
        }
        if (enums.length == 0 || enums.length == 1) {
            return true;
        }
        Enum<?> elementZero = enums[0];
        for (Enum<?> anEnum : enums) {
            if (elementZero == null && anEnum == null || elementZero == null != (anEnum == null) || Objects.equals(elementZero.name(), anEnum.name())) continue;
            return false;
        }
        return true;
    }

    public static boolean enumHasName(String enumName, Class<? extends Enum> enumClass) {
        if (enumName == null) {
            throw new NullPointerException("enumName is null");
        }
        if (enumClass == null) {
            throw new NullPointerException("enumClass is null");
        }
        for (Enum anEnum : enumClass.getEnumConstants()) {
            if (!enumName.equals(anEnum.name())) continue;
            return true;
        }
        return false;
    }

    public static boolean includedByEnum(Enum<?> enumElement, Class<? extends Enum> enumClass) {
        if (enumElement == null) {
            throw new NullPointerException("enumElement is null");
        }
        return EnumComparisonUtils.enumHasName(enumElement.name(), enumClass);
    }

    public static <T extends Enum> T getEnumItem(Enum<?> enumElement, Class<T> enumClass) {
        if (enumElement == null) {
            throw new NullPointerException("enumElement is null");
        }
        if (enumClass == null) {
            throw new NullPointerException("enumClass is null");
        }
        for (Enum item : (Enum[])enumClass.getEnumConstants()) {
            if (!item.name().equals(enumElement.name())) continue;
            return (T)item;
        }
        throw new IllegalStateException("element  " + enumElement + " not found in " + enumClass);
    }

    static boolean doCompareEnums(Class<? extends Enum> e1, Class<? extends Enum> e2) {
        if (e1 == null) {
            throw new NullPointerException("e1 is null");
        }
        if (e2 == null) {
            throw new NullPointerException("e2 is null");
        }
        return EnumComparisonUtils.compareEnumClasses(e1, e2, null);
    }

    private static boolean containsAll(Enum[] contained, Enum[] containing) {
        return Stream.of(containing).map(Enum::name).collect(Collectors.toList()).containsAll(Stream.of(contained).map(Enum::name).collect(Collectors.toList()));
    }

    @Deprecated
    private static <T1 extends Enum, T2 extends Enum> boolean oldCompareEnumClasses(Class<T1> e1, Class<T2> e2, EntityComparator<T1, T2> comparator) {
        Enum[] enumConstants2;
        if (e1 == e2) {
            return true;
        }
        Enum[] enumConstants1 = (Enum[])e1.getEnumConstants();
        if (enumConstants1.length != (enumConstants2 = (Enum[])e2.getEnumConstants()).length) {
            return false;
        }
        if (enumConstants1.length == 0) {
            return true;
        }
        if (!EnumComparisonUtils.containsAll(enumConstants1, enumConstants2)) {
            return false;
        }
        if (!EnumComparisonUtils.containsAll(enumConstants2, enumConstants1)) {
            return false;
        }
        if (comparator == null) {
            return true;
        }
        for (Enum t1 : enumConstants1) {
            for (Enum t2 : enumConstants2) {
                if (!t2.name().equals(t1.name()) || comparator.areEqual(t1, t2)) continue;
                return false;
            }
        }
        return true;
    }

    private static <T1 extends Enum, T2 extends Enum> boolean compareEnumClasses(Class<T1> e1, Class<T2> e2, EntityComparator<T1, T2> comparator) {
        Enum[] enumConstants2;
        if (e1 == e2) {
            return true;
        }
        Enum[] enumConstants1 = (Enum[])e1.getEnumConstants();
        if (enumConstants1.length != (enumConstants2 = (Enum[])e2.getEnumConstants()).length) {
            return false;
        }
        if (enumConstants1.length == 0) {
            return true;
        }
        if (!EnumComparisonUtils.containsAll(enumConstants1, enumConstants2)) {
            return false;
        }
        if (!EnumComparisonUtils.containsAll(enumConstants2, enumConstants1)) {
            return false;
        }
        if (comparator == null) {
            return true;
        }
        for (Enum t1 : enumConstants1) {
            for (Enum t2 : enumConstants2) {
                if (!t2.name().equals(t1.name()) || comparator.areEqual(t1, t2)) continue;
                return false;
            }
        }
        return true;
    }

    @SafeVarargs
    public static boolean compareOrdinals(Class<? extends Enum> ... enumerations) {
        List list = Stream.of(enumerations).map(c -> Stream.of(c.getEnumConstants()).collect(Collectors.toMap(Enum::name, Enum::ordinal))).collect(Collectors.toList());
        if (list.size() == 0 || list.size() == 1) {
            return true;
        }
        Map first = (Map)list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            Map current = (Map)list.get(i);
            for (Map.Entry entry : first.entrySet()) {
                if (Objects.equals(entry.getValue(), current.get(entry.getKey()))) continue;
                return false;
            }
        }
        return true;
    }

    @SafeVarargs
    public static void checkIfEnumOrdinalsEqual(Class<? extends Enum> ... enumerations) {
        LazyEval<String> enumerationNames = LazyEval.eval(() -> Stream.of(enumerations).map(Class::getName).collect(Collectors.joining(", ")));
        if (!EnumComparisonUtils.compareEnums(enumerations)) {
            throw new IllegalStateException("enumerations are not equal " + enumerationNames.value());
        }
        if (!EnumComparisonUtils.compareOrdinals(enumerations)) {
            throw new IllegalStateException("enumerations " + enumerationNames.value() + " contain different ordinals");
        }
    }

    public static interface EntityComparator<T1, T2> {
        public boolean areEqual(T1 var1, T2 var2);
    }
}

