/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.common.map;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class MapBuilder<K, V> {
    private final Supplier<Map<K, V>> mapSupplier;
    private Map<K, V> map;

    public static <K, V> MapBuilder<K, V> of(Supplier<Map<K, V>> mapSupplier) {
        return new MapBuilder<K, V>(mapSupplier);
    }

    public static <K, V> MapBuilder<K, V> of() {
        return MapBuilder.of(HashMap::new);
    }

    public MapBuilder(Supplier<Map<K, V>> mapSupplier) {
        this.mapSupplier = Objects.requireNonNull(mapSupplier);
    }

    public MapBuilder<K, V> put(K k, V v) {
        this.requireMap().put(k, v);
        return this;
    }

    public Map<K, V> build() {
        return this.requireMap();
    }

    private Map<K, V> requireMap() {
        if (this.map == null) {
            this.map = this.mapSupplier.get();
        }
        return this.map;
    }
}

