/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.methodfinder;

import com.steammachine.common.lazyeval.LazyEval;
import com.steammachine.common.utils.ResourceUtils;
import com.steammachine.common.utils.commonutils.CommonUtils;
import com.steammachine.methodfinder.ClassMethodTable;
import com.steammachine.methodfinder.Context;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MethodFinder {
    public static Method call(Predicate<Class> classCriteria, Predicate<Method> methodCriteria) {
        Objects.requireNonNull(methodCriteria);
        Objects.requireNonNull(classCriteria);
        LazyEval<Signatures> methods = LazyEval.eval(DefaultSignatures::new);
        Stream<StackTraceElement> stackTraceStream = Stream.of(Thread.currentThread().getStackTrace());
        return stackTraceStream.map(Context::new).map(c -> c.updateClass(MethodFinder.getClass(c.element().getClassName()))).filter(c -> classCriteria.test(c.clazz())).map(c -> c.updateMethod(MethodFinder.getMethod(c.clazz(), c.element().getMethodName(), methods, c.element().getLineNumber()))).filter(Context::everithingIsSet).map(Context::checkEverithingIsSet).filter(c -> methodCriteria.test(c.method())).map(Context::method).findFirst().orElse(null);
    }

    private static Class getClass(String className) {
        Objects.requireNonNull(className);
        return CommonUtils.suppress(() -> Thread.currentThread().getContextClassLoader().loadClass(className));
    }

    private static Method getMethod(Class clazz, String methodName, LazyEval<Signatures> methodsMap, int position) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(methodsMap);
        if (position < 0) {
            return null;
        }
        List methods = Stream.of(clazz.getDeclaredMethods()).filter(m -> methodName.equals(m.getName())).collect(Collectors.toList());
        if (methods.isEmpty()) {
            return null;
        }
        Map.Entry entry = methodsMap.value().get(clazz).entrySet().stream().filter(en -> ((ClassMethodTable.SourceCodePosition)en.getValue()).hasPosition()).filter(en -> ((ClassMethodTable.SourceCodePosition)en.getValue()).inlinerange(position)).findFirst().orElse(null);
        if (entry == null) {
            return null;
        }
        return methods.stream().filter(m -> ClassMethodTable.methodSignature(m).equals(entry.getKey())).findFirst().orElse(null);
    }

    public static Map<String, ClassMethodTable.SourceCodePosition> methodsMap(Class clazz) {
        Map<String, ClassMethodTable.SourceCodePosition> map;
        Objects.requireNonNull(clazz);
        InputStream classStream = clazz.getResourceAsStream(ResourceUtils.classFileName(clazz));
        if (classStream == null) {
            return Collections.emptyMap();
        }
        try {
            map = ClassMethodTable.readClassFromInputStream(classStream);
        }
        catch (Throwable throwable) {
            try {
                classStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        classStream.close();
        return map;
    }

    public static class DefaultSignatures
    implements Signatures {
        private final Map<Class, LazyEval<Map<String, ClassMethodTable.SourceCodePosition>>> evalMap = new HashMap<Class, LazyEval<Map<String, ClassMethodTable.SourceCodePosition>>>();

        @Override
        public Map<String, ClassMethodTable.SourceCodePosition> get(Class clazz) {
            this.evalMap.putIfAbsent(clazz, LazyEval.eval(() -> MethodFinder.methodsMap(clazz)));
            return this.evalMap.get(clazz).value();
        }
    }

    public static interface Signatures {
        public Map<String, ClassMethodTable.SourceCodePosition> get(Class var1);
    }
}

