package com.steammachine.jsonchecker.impl.ver1;

import com.steammachine.jsonchecker.types.TreeNode;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

/**
 * Created 01.12.2017.
 *
 *  Несмотря на то, что класс объявлен как public его использование не предполагается извне пакета
 *  он может быть удален в любой момент.
 * @author Vladimir Bogodukhov
 **/
public class DefaultTreeNode implements TreeNode {

    private final List<TreeNode> children = new ArrayList<>();
    private final Object data;

    public DefaultTreeNode(Object data) {
        this.data = Objects.requireNonNull(data);
    }

    public void addChild(TreeNode child) {
        children.add(child);
    }

    @Override
    public Object object() {
        return data;
    }

    @Override
    public Iterator<TreeNode> iterator() {
        return children.iterator();
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DefaultTreeNode)) return false;

        DefaultTreeNode treeNodes = (DefaultTreeNode) o;

        if (children != null ? !children.equals(treeNodes.children) : treeNodes.children != null) return false;
        return data != null ? data.equals(treeNodes.data) : treeNodes.data == null;
    }

    @Override
    public int hashCode() {
        int result = children != null ? children.hashCode() : 0;
        result = 31 * result + (data != null ? data.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "DefaultTreeNode{" +
                "children=" + children +
                ", data=" + data +
                '}';
    }
}
