package com.steammachine.jsonchecker.utils.compatibletypescomparator.ver2;

/**
 *
 * Вспомогательный тип для сравнения элементов
 * Created 01.12.2017.
 * @author Vladimir Bogodukhov
 **/
public interface CompareTo<Type1, Type2> {
    /**
     * @return Первый тип объекта сравнения
     */
    Class<Type1> type1();

    /**
     * @return Второй объекта сравнения
     */
    Class<Type2> type2();

    /**
     * Метод сравнения
     *
     * @param value1 -
     * @param value2 -
     * @return -
     */
    boolean isEqualTo(Type1 value1, Type2 value2);
}
