package other.common.log;

import org.apache.log4j.Logger;

/**
 * Created by Vladimir Bogodukhov at 08/05/15  14:35
 * Обертка логирования {@link Logging} на основе  {@link org.apache.log4j.Logger}
 *
 * @author Vladimir Bogodukhov
 */
public class Log4jLogging implements Logging {

    private final Logger logger;

    public Log4jLogging(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger is null");
        }
        this.logger = logger;
    }

    @Override
    public void trace(Object message) {
        logger.trace(message);
    }

    @Override
    public void trace(Object message, Throwable t) {
        logger.trace(message, t);
    }

    @Override
    public void debug(Object message) {
        logger.debug(message);
    }

    @Override
    public void debug(Object message, Throwable t) {
        logger.debug(message, t);
    }

    @Override
    public void info(Object message) {
        logger.info(message);
    }

    @Override
    public void info(Object message, Throwable t) {
        logger.info(message, t);
    }

    @Override
    public void error(Object message) {
        logger.error(message);
    }

    @Override
    public void error(Object message, Throwable t) {
        logger.error(message, t);
    }
}
