package other.common.log;

/**
 * Интерфейс обертка методов записи сообщений логирования с различным уровнем.
 * Используется для тестирования выдаваемых в лог сообщений.
 *
 * @author Vladimir Bogodukhov
 * Created by Vladimir Bogodukhov at 08/05/15  14:34
 */
public interface Logging {


    /**
     * Запись логирования с уровнем trace
     *
     * @param message - объект сообщения
     */
    void trace(Object message);

    /**
     * Запись логирования с уровнем trace
     *
     * @param message - объект сообщения
     * @param t - объект исключения
     */
    void trace(Object message, Throwable t);

    /**
     * Запись логирования с уровнем trace
     *
     * @param message - объект сообщения
     */
    void debug(Object message);

    /**
     * Запись логирования с уровнем debug
     *
     * @param message - объект сообщения
     * @param t - объект исключения
     */
    void debug(Object message, Throwable t);

    /**
     * Запись логирования с уровнем info
     *
     * @param message - объект сообщения
     */
    void info(Object message);


    /**
     * Запись логирования с уровнем info
     *
     * @param message - объект сообщения
     * @param t - объект исключения
     */
    void info(Object message, Throwable t);

    /**
     * Запись логирования с уровнем error
     *
     * @param message - объект сообщения
     */
    void error(Object message);

    /**
     * Запись логирования с уровнем error
     *
     * @param message - объект сообщения
     * @param t - объект исключения
     */
    void error(Object message, Throwable t);

}
