/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.defaults;

import com.steammachine.jsonchecker.impl.flatter2.Element;
import com.steammachine.jsonchecker.impl.flatter2.Id;
import com.steammachine.jsonchecker.types.Path;
import com.steammachine.jsonchecker.types.PathParticle;
import com.steammachine.jsonchecker.types.PathRepresentation;
import java.util.List;

public class MonkeyPathRepresentation {
    public static final PathRepresentation REPRESENTATION = MonkeyPathRepresentation::asString;

    private static String asString(Path path) {
        StringBuilder builder = new StringBuilder();
        block11: for (int index = 0; index < path.particles().size(); ++index) {
            switch (path.particles().get(index).type()) {
                case DELIMETR: {
                    builder.append("/");
                    continue block11;
                }
                case ELEMENT: {
                    Element current = MonkeyPathRepresentation.current(path.particles(), index);
                    Id identifier = null;
                    for (Id id : current.list()) {
                        if (identifier == null) {
                            identifier = id;
                            continue;
                        }
                        if (!identifier.id().startsWith("@") || id.id().contains("@")) continue;
                        identifier = id;
                    }
                    if (identifier == null) {
                        builder.append("UNKNOWN");
                        continue block11;
                    }
                    switch (identifier.type()) {
                        case notArrayItem: {
                            builder.append(identifier.id());
                            continue block11;
                        }
                        case arrayItem: {
                            builder.append("[").append(identifier.index()).append("]");
                            continue block11;
                        }
                        case anyArrayItem: {
                            builder.append("[*]");
                            continue block11;
                        }
                    }
                    throw new IllegalStateException("unknown type " + (Object)((Object)identifier.type()));
                }
                case NO_TRESPASING: {
                    builder.append("[NO_WAY_THROUGH_THIS_PATH]");
                    continue block11;
                }
                case ANYELEMENT: {
                    builder.append("*");
                    continue block11;
                }
                default: {
                    throw new IllegalStateException("unknown type " + (Object)((Object)path.particles().get(index).type()));
                }
            }
        }
        return "" + builder;
    }

    private static Element current(List<PathParticle> particles, int index) {
        return (Element)particles.get(index);
    }
}

