/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.impl.flatter2;

import com.steammachine.jsonchecker.impl.flatter2.Id;
import com.steammachine.jsonchecker.types.PathParticle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Element
implements PathParticle {
    private static final Element EMPTY_ELEMENT = new Element(Collections.emptyList());
    private final List<Id> list;

    protected Element(List<Id> list) {
        this.list = Collections.unmodifiableList(list);
    }

    public static Element empty() {
        return EMPTY_ELEMENT;
    }

    public static Element of(Id identifier) {
        Objects.requireNonNull(identifier);
        return new Element(Collections.singletonList(identifier));
    }

    public List<Id> list() {
        return this.list;
    }

    public Element addId(Id id) {
        Objects.requireNonNull(id);
        ArrayList<Id> list = new ArrayList<Id>();
        list.addAll(this.list);
        list.add(id);
        return new Element(list);
    }

    @Override
    public PathParticle.ParticleType type() {
        return PathParticle.ParticleType.ELEMENT;
    }

    @Deprecated
    public static Element merge(Element e1, Element e2) {
        Objects.requireNonNull(e1);
        Objects.requireNonNull(e2);
        ArrayList<Id> list = new ArrayList<Id>();
        list.addAll(e1.list);
        list.addAll(e2.list);
        return new Element(list);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Element)) {
            return false;
        }
        Element element = (Element)o;
        return this.list.equals(element.list);
    }

    public int hashCode() {
        return this.list.hashCode();
    }
}

