/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.impl.flatter2;

import java.util.Objects;

public class ValueKey {
    private final Object holder;
    private final String propertyName;
    private final Integer arrayIndex;

    private ValueKey(Object holder, String propertyName, Integer arrayIndex) {
        this.holder = Objects.requireNonNull(holder);
        this.propertyName = propertyName;
        this.arrayIndex = arrayIndex;
        if (propertyName == null == (arrayIndex == null)) {
            throw new IllegalArgumentException("propertyName or arrayIndex must be defined");
        }
    }

    public Object holder() {
        return this.holder;
    }

    public String propertyName() {
        return this.propertyName;
    }

    public Integer arrayIndex() {
        return this.arrayIndex;
    }

    public static ValueKey of(Object o, String name) {
        return new ValueKey(o, name, null);
    }

    public static ValueKey of(Object o, int index) {
        return new ValueKey(o, null, index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValueKey)) {
            return false;
        }
        ValueKey nodeKey = (ValueKey)o;
        if (this.holder != nodeKey.holder) {
            return false;
        }
        if (this.propertyName != null ? !this.propertyName.equals(nodeKey.propertyName) : nodeKey.propertyName != null) {
            return false;
        }
        return this.arrayIndex != null ? this.arrayIndex.equals(nodeKey.arrayIndex) : nodeKey.arrayIndex == null;
    }

    public int hashCode() {
        int result = System.identityHashCode(this.holder);
        result = 31 * result + (this.propertyName != null ? this.propertyName.hashCode() : 0);
        result = 31 * result + (this.arrayIndex != null ? this.arrayIndex.hashCode() : 0);
        return result;
    }
}

