/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.impl.ver1;

import com.steammachine.common.utils.commonutils.CommonUtils;
import com.steammachine.jsonchecker.types.UnmappedProperties;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ObjectInformation {
    private final Object parentobject;
    private final Object object;
    private final String instanceName;
    private final Map<String, List<Method>> classInfo;
    private final UnmappedProperties defaultProps;
    private final List<FixupItem> fixups = new ArrayList<FixupItem>();
    private final Map<String, Object> nameSpace;
    public static final Map<String, Class> VALUE_CLASSES = Stream.of(String.class, Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class, BigInteger.class).collect(Collectors.toMap(Class::getName, c -> c));

    public ObjectInformation(Object parentobject, Object object, String instanceName, Map<String, Object> nameSpace) {
        this.parentobject = parentobject;
        this.object = Objects.requireNonNull(object);
        this.defaultProps = object instanceof UnmappedProperties ? (UnmappedProperties)object : null;
        this.nameSpace = Objects.requireNonNull(nameSpace);
        this.instanceName = instanceName;
        this.classInfo = ObjectInformation.loadClassInfo(object.getClass());
    }

    public Object object() {
        return this.object;
    }

    public Object parentobject() {
        return this.parentobject;
    }

    public void setValue(String propertyName, Object value) {
        List<Method> methods = this.classInfo.get("set" + ObjectInformation.capitalize(propertyName));
        if (methods == null) {
            if (this.defaultProps == null) {
                throw new IllegalStateException("");
            }
            this.defaultProps.setValue(propertyName, "" + value);
            return;
        }
        if (methods.size() != 1) {
            throw new IllegalStateException("multyprops are not supported yet.  there must be only one set" + ObjectInformation.capitalize(propertyName) + " method");
        }
        Method method = methods.get(0);
        method.setAccessible(true);
        CommonUtils.suppress(() -> method.invoke(this.object, value));
    }

    public void setValueCandidate(String propertyName, String value) {
        List<Method> methods = this.classInfo.get("set" + ObjectInformation.capitalize(propertyName));
        if (methods == null) {
            if (this.defaultProps == null) {
                throw new IllegalStateException("no methods found for property " + propertyName);
            }
            this.defaultProps.setValue(propertyName, value);
            return;
        }
        if (methods.size() != 1) {
            throw new IllegalStateException("multyprops are not supported yet.  there must be only one set" + ObjectInformation.capitalize(propertyName) + " method");
        }
        Method method = methods.get(0);
        Class<?> type = method.getParameterTypes()[0];
        if (!ObjectInformation.isValue(type)) {
            this.fixups.add(new FixupItem(method, value));
        } else {
            Object valueToSet = ObjectInformation.value(type, value);
            method.setAccessible(true);
            CommonUtils.suppress(() -> method.invoke(this.object, valueToSet));
        }
    }

    public void fixup() {
        this.fixups.forEach(FixupItem::fixup);
    }

    private static Map<String, List<Method>> loadClassInfo(Class clazz) {
        HashMap methodMap = new HashMap();
        for (Class c = clazz; c != null; c = c.getSuperclass()) {
            Stream.of(c.getDeclaredMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).filter(m -> m.getName().startsWith("set")).filter(m -> m.getReturnType() == Void.TYPE).filter(m -> m.getParameterCount() == 1).map(m -> new MethodDataInfoKey((Method)m, m.getName(), m.getParameterTypes()[0])).forEach(mi -> methodMap.putIfAbsent(mi, mi.method()));
        }
        HashMap<String, List<Method>> result = new HashMap<String, List<Method>>();
        methodMap.entrySet().forEach(t -> {
            result.putIfAbsent(((MethodDataInfoKey)t.getKey()).name(), new ArrayList());
            ((List)result.get(((MethodDataInfoKey)t.getKey()).name())).add(t.getValue());
        });
        return result;
    }

    public static boolean isValue(Class typeParam) {
        return VALUE_CLASSES.containsValue(typeParam);
    }

    public static Object value(Class typeParam, String value) {
        Objects.requireNonNull(typeParam);
        if (value == null) {
            return null;
        }
        if (typeParam == String.class) {
            return value;
        }
        if (typeParam == Boolean.TYPE) {
            return ObjectInformation.parseBoolean(value);
        }
        if (typeParam == Boolean.class) {
            return ObjectInformation.parseBoolean(value);
        }
        if (typeParam == Byte.TYPE) {
            return Byte.parseByte(value);
        }
        if (typeParam == Byte.class) {
            return Byte.parseByte(value);
        }
        if (typeParam == Short.TYPE) {
            return Short.parseShort(value);
        }
        if (typeParam == Short.class) {
            return Short.parseShort(value);
        }
        if (typeParam == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (typeParam == Integer.class) {
            return Integer.parseInt(value);
        }
        if (typeParam == Long.TYPE) {
            return Long.parseLong(value);
        }
        if (typeParam == Long.class) {
            return Long.parseLong(value);
        }
        if (typeParam == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (typeParam == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (typeParam == Double.TYPE) {
            return Double.parseDouble(value);
        }
        if (typeParam == Double.class) {
            return Double.parseDouble(value);
        }
        if (typeParam == BigDecimal.class) {
            return new BigDecimal(value);
        }
        if (typeParam == BigInteger.class) {
            return new BigInteger(value);
        }
        throw new IllegalStateException("type " + typeParam + " is not supported");
    }

    public static Class getLoadedClass(String classTypeName) {
        Objects.requireNonNull(classTypeName);
        if (VALUE_CLASSES.get(classTypeName) != null) {
            return VALUE_CLASSES.get(classTypeName);
        }
        return (Class)CommonUtils.suppress(() -> Class.forName(classTypeName));
    }

    private static String capitalize(String word) {
        Objects.requireNonNull(word);
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }

    private static boolean parseBoolean(String value) {
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        throw new IllegalStateException(" " + value + " is not valid boolean VALUE");
    }

    private static class MethodDataInfoKey {
        private final Method method;
        private final String name;
        private final Class<?> paramType;

        MethodDataInfoKey(Method method, String name, Class<?> paramType) {
            this.method = Objects.requireNonNull(method);
            this.name = Objects.requireNonNull(name);
            this.paramType = Objects.requireNonNull(paramType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodDataInfoKey)) {
                return false;
            }
            MethodDataInfoKey that = (MethodDataInfoKey)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return this.paramType != null ? this.paramType.equals(that.paramType) : that.paramType == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.paramType != null ? this.paramType.hashCode() : 0);
            return result;
        }

        public Method method() {
            return this.method;
        }

        public String name() {
            return this.name;
        }

        public Class<?> paramType() {
            return this.paramType;
        }
    }

    private class FixupItem {
        private final String objectName;
        private final Method method;

        public FixupItem(Method method, String objectName) {
            this.method = Objects.requireNonNull(method);
            this.method.setAccessible(true);
            this.objectName = objectName;
        }

        public void fixup() {
            if (!ObjectInformation.this.nameSpace.containsKey(this.objectName)) {
                throw new IllegalStateException("object '" + this.objectName + "' not found");
            }
            Object refValue = ObjectInformation.this.nameSpace.get(this.objectName);
            CommonUtils.suppress(() -> this.method.invoke(ObjectInformation.this.object, refValue));
        }
    }
}

