/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.types;

import com.steammachine.common.lazyeval.LazyEval;
import com.steammachine.common.utils.commonutils.CommonUtils;
import com.steammachine.jsonchecker.impl.flatter2.AuxTypes;
import com.steammachine.jsonchecker.impl.flatter2.Element;
import com.steammachine.jsonchecker.impl.flatter2.Id;
import com.steammachine.jsonchecker.types.PathParticle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Path {
    private final List<PathParticle> particles;
    private final LazyEval<List<Element>> elements = LazyEval.eval((Supplier)new Supplier<List<Element>>(){

        @Override
        public List<Element> get() {
            return Path.this.particles.stream().filter(p -> p.type().in(PathParticle.ParticleType.ELEMENT, PathParticle.ParticleType.ANYELEMENT)).map(p -> (Element)p).collect(Collectors.toList());
        }
    });

    public static Builder builder() {
        return new Builder();
    }

    private Path(List<PathParticle> particles) {
        this.particles = Objects.requireNonNull(particles);
    }

    public static Path of() {
        return new Path(Collections.emptyList());
    }

    public List<Element> elements() {
        return (List)this.elements.value();
    }

    public Path del() {
        if (this.particles.size() > 0 && this.particles.get(this.particles.size() - 1).type() == PathParticle.ParticleType.DELIMETR) {
            throw new IllegalStateException();
        }
        return new Path(this.addParticleToCopy(AuxTypes.DELIMETR));
    }

    public ElementAndPath id(Id identifier) {
        Objects.requireNonNull(identifier);
        if (this.particles.size() > 0 && this.particles.get(this.particles.size() - 1).type() != PathParticle.ParticleType.DELIMETR) {
            throw new IllegalStateException();
        }
        Element element = Element.of(identifier);
        return new ElementAndPath(element, new Path(this.addParticleToCopy(element)));
    }

    public Path addId(Id identifier) {
        CommonUtils.check(() -> this.particles.isEmpty() || this.particles.get(this.particles.size() - 1).type().in(PathParticle.ParticleType.DELIMETR, PathParticle.ParticleType.ELEMENT), IllegalStateException::new);
        List<PathParticle> pathParticles = this.changeableParticles();
        if (pathParticles.isEmpty()) {
            pathParticles.add(Element.of(identifier));
        } else {
            PathParticle particle = pathParticles.get(this.particles.size() - 1);
            if (particle.type().in(PathParticle.ParticleType.DELIMETR)) {
                pathParticles.add(Element.of(identifier));
            } else if (particle.type().in(PathParticle.ParticleType.ELEMENT)) {
                pathParticles.set(this.particles.size() - 1, ((Element)particle).addId(identifier));
            }
        }
        return new Path(Collections.unmodifiableList(pathParticles));
    }

    public PathParticle.ParticleType particleType(int index) {
        return this.particles.get(index).type();
    }

    public boolean startsWith(Path part) {
        return part.particles().size() <= this.particles.size() && this.particles.subList(0, part.particles().size()).equals(part.particles());
    }

    public boolean endsWith(Path part) {
        return part.particles().size() <= this.particles.size() && this.particles.subList(this.particles.size() - part.particles().size(), this.particles.size()).equals(part.particles());
    }

    public Path subPath(int startIndex) {
        return new Path(Collections.unmodifiableList(this.changeableParticles().subList(startIndex, this.particles.size())));
    }

    public Path subPath(int startIndex, int endIndex) {
        return new Path(Collections.unmodifiableList(this.changeableParticles().subList(startIndex, endIndex)));
    }

    public Path notPassable() {
        if (this.particles.size() > 0 && this.particles.get(this.particles.size() - 1).type() != PathParticle.ParticleType.DELIMETR) {
            throw new IllegalStateException();
        }
        return new Path(this.addParticleToCopy(AuxTypes.NO_TRESSPASSING));
    }

    public Path updateParticle(PathParticle particle, int index) {
        Objects.requireNonNull(particle);
        List<PathParticle> newParts = this.changeableParticles();
        CommonUtils.check(() -> particle.type() == ((PathParticle)newParts.get(index)).type(), IllegalStateException::new);
        newParts.set(index, particle);
        return new Path(newParts);
    }

    public List<PathParticle> particles() {
        return this.particles;
    }

    public boolean isPassable() {
        return this.particles.stream().noneMatch(p -> p.type() == PathParticle.ParticleType.NO_TRESPASING);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path path = (Path)o;
        return this.particles != null ? this.particles.equals(path.particles) : path.particles == null;
    }

    public int hashCode() {
        return this.particles != null ? this.particles.hashCode() : 0;
    }

    public String toString() {
        return this.particles.stream().map(Path::ident).collect(Collectors.joining());
    }

    private static String ident(PathParticle p) {
        switch (p.type()) {
            case ANYELEMENT: {
                return "*";
            }
            case DELIMETR: {
                return "/";
            }
            case NO_TRESPASING: {
                return "->XXX";
            }
            case ELEMENT: {
                return ((Element)p).list().stream().map(Path::idRep).collect(Collectors.joining());
            }
        }
        throw new IllegalStateException("unknown type " + (Object)((Object)p.type()));
    }

    private static String idRep(Id id) {
        switch (id.type()) {
            case notArrayItem: {
                return id.id();
            }
            case arrayItem: {
                return "[" + id.index() + "]";
            }
            case anyArrayItem: {
                return "[*]";
            }
        }
        throw new IllegalStateException("unknown type " + (Object)((Object)id.type()));
    }

    private List<PathParticle> addParticleToCopy(PathParticle particle) {
        List<PathParticle> particles = this.changeableParticles();
        particles.add(particle);
        particles = Collections.unmodifiableList(particles);
        return particles;
    }

    private List<PathParticle> changeableParticles() {
        return new ArrayList<PathParticle>(this.particles);
    }

    public static class Builder {
        private final List<PathParticle> particles = new ArrayList<PathParticle>();
        private volatile boolean locked = false;

        public static Builder builder() {
            return new Builder();
        }

        public Builder ast() {
            this.checkLocked(false);
            this.particles.add(AuxTypes.ASTERIX);
            return this;
        }

        public Builder noTrespassing() {
            this.checkLocked(false);
            this.particles.add(AuxTypes.NO_TRESSPASSING);
            return this;
        }

        public Builder del() {
            this.checkLocked(false);
            this.particles.add(AuxTypes.DELIMETR);
            return this;
        }

        public Builder obj(String identifier) {
            this.checkLocked(false);
            this.particles.add(Element.of(Id.obj(identifier)));
            return this;
        }

        public Builder arr(int index) {
            this.checkLocked(false);
            this.particles.add(Element.of(Id.arr(index)));
            return this;
        }

        public Builder anyArr() {
            this.checkLocked(false);
            this.particles.add(Element.of(Id.anyArr()));
            return this;
        }

        public Builder rawElement(Element element) {
            this.checkLocked(false);
            this.particles.add(element);
            return this;
        }

        public Path get() {
            Path path = new Path(Collections.unmodifiableList(this.particles));
            this.lock();
            return path;
        }

        private void lock() {
            this.locked = true;
        }

        private void checkLocked(boolean locked) {
            CommonUtils.check(() -> this.locked == locked, IllegalStateException::new);
        }
    }

    public static class ElementAndPath {
        private final Element element;
        private final Path path;

        public ElementAndPath(Element element, Path path) {
            this.element = Objects.requireNonNull(element);
            this.path = Objects.requireNonNull(path);
        }

        public Element element() {
            return this.element;
        }

        public Path path() {
            return this.path;
        }

        public Path del() {
            return this.path.del();
        }

        public ElementAndPath id(Id identifier) {
            return this.path.id(identifier);
        }
    }
}

