/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.org.junit5.extensions.dynamictests.impls;

import com.steammachine.org.junit5.extensions.dynamictests.TestInstanceFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.Executable;

public class DynamicTestUtils {
    public static final List<Class> OBJECT_PRIMITIVES = Arrays.asList(Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, String.class);
    public static final List<Class> OBJECT_PRIMITIVES_STRING = Arrays.asList(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Character.TYPE, Character.class, String.class);

    public static List<DynamicTest> generateAsList(Object nexus, List<Object[]> paramsCandidates, List<Class> paramTypes, TestInstanceFactory testInstanceFactory) {
        Objects.requireNonNull(nexus, "nexus is null");
        Objects.requireNonNull(paramsCandidates, "params is null");
        Objects.requireNonNull(paramTypes, "paramTypes is null");
        Objects.requireNonNull(testInstanceFactory, "testInstanceFactory is null");
        Stream.Builder<Class<?>> builder = Stream.builder();
        for (Class<?> clazz = nexus.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            builder.add(clazz);
        }
        return builder.build().flatMap(cl -> Stream.of(cl.getDeclaredMethods())).filter(method -> !Modifier.isStatic(method.getModifiers())).filter(method -> !Modifier.isPrivate(method.getModifiers())).filter(method -> !Modifier.isNative(method.getModifiers())).filter(method -> method.getDeclaringClass() != Object.class).filter(method -> method.getReturnType() == Void.TYPE).filter(method -> method.getParameterCount() == paramTypes.size()).map(method -> {
            List<List<Object>> params = DynamicTestUtils.getParamList(paramsCandidates, method);
            class MethodHolder {
                final Method method;
                final List<List<Object>> callParams;

                MethodHolder(Method method, List<List<Object>> callParams) {
                    this.method = Objects.requireNonNull(method);
                    this.callParams = Objects.requireNonNull(callParams);
                }

                public Method method() {
                    return this.method;
                }

                public List<List<Object>> callParamsSet() {
                    return this.callParams;
                }
            }
            return !params.isEmpty() ? new MethodHolder((Method)method, params) : null;
        }).filter(Objects::nonNull).flatMap(mh -> DynamicTestUtils.dynamicTestStream(nexus, paramTypes, testInstanceFactory, mh.callParamsSet(), mh.method())).collect(Collectors.toList());
    }

    private static Stream<? extends DynamicTest> dynamicTestStream(Object nexus, List<Class> paramTypes, TestInstanceFactory testInstanceFactory, List<List<Object>> callParamsSet, Method method) {
        Stream.Builder<DynamicTest> sb = Stream.builder();
        int j = 0;
        for (List<Object> callParams : callParamsSet) {
            sb.add(DynamicTestUtils.createDynamicTest(testInstanceFactory, nexus, method, paramTypes, callParams, j++));
        }
        return sb.build();
    }

    private static List<List<Object>> getParamList(List<Object[]> paramsCandidates, Method method) {
        ArrayList<List<Object>> params = new ArrayList<List<Object>>();
        for (Object[] tp : paramsCandidates) {
            List<Object> paramCandidates = Arrays.asList(tp);
            if (!DynamicTestUtils.isMethodCompatible(method, paramCandidates)) continue;
            params.add(paramCandidates);
        }
        return params;
    }

    private static DynamicTest createDynamicTest(TestInstanceFactory testInstanceFactory, Object nexus, Method method, List<Class> paramTypes, List<Object> params, int position) {
        String displayName = DynamicTestUtils.methodWithParams(method, params, position);
        return testInstanceFactory.newDynamicTest(displayName, DynamicTestUtils.formExec(nexus, method, params));
    }

    private static String methodWithParams(Method method, List<Object> params, int position) {
        Objects.requireNonNull(method);
        Objects.requireNonNull(params);
        StringBuilder builder = new StringBuilder();
        builder.append(method.getName()).append("(");
        builder.append(DynamicTestUtils.paramValues(params));
        builder.append(")");
        return "" + builder;
    }

    private static Executable formExec(Object nexus, Method method, List<Object> params) {
        Objects.requireNonNull(nexus);
        Objects.requireNonNull(method);
        Objects.requireNonNull(params);
        Object[] arguments = params.toArray(new Object[params.size()]);
        return () -> {
            if (!method.isAccessible()) {
                method.setAccessible(true);
                try {
                    try {
                        method.invoke(nexus, arguments);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                }
                finally {
                    method.setAccessible(false);
                }
            }
        };
    }

    public static boolean isMethodCompatible(Method method, List<Object> paramCandidates) {
        Objects.requireNonNull(method);
        Objects.requireNonNull(paramCandidates);
        if (method.getParameterCount() != paramCandidates.size()) {
            return false;
        }
        boolean result = true;
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            result = result && DynamicTestUtils.isTypeAssignableFromValue(parameterTypes[i], paramCandidates.get(i));
        }
        return result;
    }

    public static boolean isTypeAssignableFromValue(Class typeToAssignTo, Object value) {
        Objects.requireNonNull(typeToAssignTo);
        if (value == null) {
            return !typeToAssignTo.isPrimitive();
        }
        Class<?> typeToAssignFrom = value.getClass();
        if (typeToAssignTo == Object.class) {
            return true;
        }
        if (DynamicTestUtils.inGroup(typeToAssignTo, Boolean.TYPE, Boolean.class)) {
            return DynamicTestUtils.inGroup(typeToAssignFrom, Boolean.TYPE, Boolean.class);
        }
        if (DynamicTestUtils.inGroup(typeToAssignTo, Byte.TYPE, Byte.class)) {
            return DynamicTestUtils.inGroup(typeToAssignFrom, Byte.TYPE, Byte.class);
        }
        if (DynamicTestUtils.inGroup(typeToAssignTo, Short.TYPE, Short.class)) {
            return DynamicTestUtils.inGroup(typeToAssignFrom, Short.TYPE, Short.class);
        }
        if (DynamicTestUtils.inGroup(typeToAssignTo, Integer.TYPE, Integer.class)) {
            return DynamicTestUtils.inGroup(typeToAssignFrom, Integer.TYPE, Integer.class);
        }
        if (DynamicTestUtils.inGroup(typeToAssignTo, Long.TYPE, Long.class)) {
            return DynamicTestUtils.inGroup(typeToAssignFrom, Long.TYPE, Long.class);
        }
        if (DynamicTestUtils.inGroup(typeToAssignTo, Float.TYPE, Float.class)) {
            return DynamicTestUtils.inGroup(typeToAssignFrom, Float.TYPE, Float.class);
        }
        if (DynamicTestUtils.inGroup(typeToAssignTo, Double.TYPE, Double.class)) {
            return DynamicTestUtils.inGroup(typeToAssignFrom, Double.TYPE, Double.class);
        }
        if (DynamicTestUtils.inGroup(typeToAssignTo, Character.TYPE, Character.class)) {
            return DynamicTestUtils.inGroup(typeToAssignFrom, Character.TYPE, Character.class);
        }
        return typeToAssignTo.isAssignableFrom(typeToAssignFrom);
    }

    static boolean inGroup(Class<?> type, Class<?> ... group) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(group);
        for (Class<?> item : group) {
            if (type != item) continue;
            return true;
        }
        return false;
    }

    public static String typeName(Class<?> type) {
        Objects.requireNonNull(type);
        if (OBJECT_PRIMITIVES.contains(type)) {
            return type.getTypeName().substring(type.getTypeName().lastIndexOf(".") + 1);
        }
        return type.getTypeName();
    }

    public static String paramValues(List<Object> paramSet, List<Class> paramTypes) {
        Objects.requireNonNull(paramSet);
        Objects.requireNonNull(paramTypes);
        if (paramSet.size() != paramTypes.size()) {
            throw new IllegalStateException("paramSet.size() != paramTypes.size()");
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < paramSet.size(); ++i) {
            b.append(b.length() > 0 ? ", " : "");
            Object value = paramSet.get(i);
            b.append(value).append(":").append(DynamicTestUtils.typeName(paramTypes.get(i))).append(value == null ? "" : ":" + DynamicTestUtils.typeName(value.getClass()));
        }
        return b.toString();
    }

    private static String paramValues(List<Object> paramSet) {
        Objects.requireNonNull(paramSet);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < paramSet.size(); ++i) {
            String value;
            builder.append(builder.length() > 0 ? ", " : "");
            if (paramSet.get(i) == null) {
                value = null;
            } else if (paramSet.get(i) instanceof Enum) {
                value = "" + DynamicTestUtils.className(paramSet.get(i).getClass()) + "." + paramSet.get(i);
            } else if (!OBJECT_PRIMITIVES_STRING.contains(paramSet.get(i).getClass())) {
                value = "" + paramSet.get(i);
            } else {
                switch (paramSet.get(i).getClass().getName()) {
                    case "boolean": 
                    case "java.lang.Boolean": {
                        value = "" + paramSet.get(i);
                        break;
                    }
                    case "byte": 
                    case "java.lang.Byte": {
                        value = "" + paramSet.get(i);
                        break;
                    }
                    case "short": 
                    case "java.lang.Short": {
                        value = "" + paramSet.get(i);
                        break;
                    }
                    case "int": 
                    case "java.lang.Integer": {
                        value = "" + paramSet.get(i);
                        break;
                    }
                    case "long": 
                    case "java.lang.Long": {
                        value = "" + paramSet.get(i) + "L";
                        break;
                    }
                    case "float": 
                    case "java.lang.Float": {
                        value = "" + paramSet.get(i);
                        break;
                    }
                    case "double": 
                    case "java.lang.Double": {
                        value = "" + paramSet.get(i);
                        break;
                    }
                    case "char": 
                    case "java.lang.Character": {
                        value = "'" + paramSet.get(i) + "'";
                        break;
                    }
                    case "java.lang.String": {
                        value = "\"" + paramSet.get(i) + "\"";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown type " + paramSet.get(i).getClass().getName());
                    }
                }
            }
            builder.append(value);
        }
        return "" + builder;
    }

    private static String className(Class<?> aClass) {
        Objects.requireNonNull(aClass);
        ArrayList<String> classNames = new ArrayList<String>();
        for (Class<?> tmp = aClass; tmp != null; tmp = tmp.getDeclaringClass()) {
            classNames.add(0, tmp.getSimpleName());
        }
        StringBuilder builder = new StringBuilder();
        for (String className : classNames) {
            builder.append(builder.length() > 0 ? "." : "");
            builder.append(className);
        }
        return "" + builder;
    }

    public static List<Class> checkTypes(List<Object[]> params) {
        Objects.requireNonNull(params);
        ArrayList types = null;
        for (Object[] group : params) {
            int i;
            if (types == null) {
                types = new ArrayList();
                for (i = 0; i < group.length; ++i) {
                    types.add(group[i] != null ? group[i].getClass() : null);
                }
                continue;
            }
            if (group.length != types.size()) {
                throw new IllegalArgumentException("param length must be equal for all elements");
            }
            for (i = 0; i < group.length; ++i) {
                if (types.get(i) == null) {
                    types.set(i, group[i].getClass());
                    continue;
                }
                if (group[i] == null || types.get(i) == null) continue;
                if (!group[i].getClass().isAssignableFrom((Class)types.get(i)) && !((Class)types.get(i)).isAssignableFrom(group[i].getClass())) {
                    throw new IllegalArgumentException("params contain incompatible types " + group[i].getClass() + " and " + types.get(i) + "  at index " + i);
                }
                if (((Class)types.get(i)).isAssignableFrom(group[i].getClass()) || !group[i].getClass().isAssignableFrom((Class)types.get(i))) continue;
                types.set(i, group[i].getClass());
            }
        }
        return types == null ? Collections.emptyList() : types;
    }

    public static class PrimTypeNames {
        public static final String BooleanTYPE = "" + Boolean.TYPE.getName();
        public static final String Boolean\u0421lass = "" + Boolean.class.getName();
        public static final String ByteTYPE = "" + Byte.TYPE.getName();
        public static final String ByteClass = "" + Byte.class.getName();
        public static final String ShortTYPE = "" + Short.TYPE.getName();
        public static final String ShortClass = "" + Short.class.getName();
        public static final String IntegerTYPE = "" + Integer.TYPE.getName();
        public static final String IntegerClass = "" + Integer.class.getName();
        public static final String LongTYPE = "" + Long.TYPE.getName();
        public static final String LongClass = "" + Long.class.getName();
        public static final String FloatTYPE = "" + Float.TYPE.getName();
        public static final String FloatClass = "" + Float.class.getName();
        public static final String DoubleTYPE = "" + Double.TYPE.getName();
        public static final String DoubleClass = "" + Double.class.getName();
        public static final String CharacterTYPE = "" + Character.TYPE.getName();
        public static final String CharacterClass = "" + Character.class.getName();
        public static final String StringClass = "" + String.class.getName();
    }
}

