/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.org.junit5.extensions.dynamictests.impls.ver4;

import com.steammachine.org.junit5.extensions.dynamictests.DynamicPoint;
import com.steammachine.org.junit5.extensions.dynamictests.DynamicTestFormationException;
import com.steammachine.org.junit5.extensions.dynamictests.TestInstanceFactory;
import com.steammachine.org.junit5.extensions.dynamictests.impls.DynamicTestUtils;
import com.steammachine.org.junit5.extensions.dynamictests.impls.ver4.DynamicTestsHelperVer4;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.Executable;

public class DynamicPointVer4
implements DynamicPoint {
    private final DynamicTestsHelperVer4 helper;
    private Object nexus;
    private List<Class> paramTypes;
    private final List<Object[]> params = new ArrayList<Object[]>();
    private List<DynamicTest> tests;
    private List<DynamicTest> addedDynamicTests = new ArrayList<DynamicTest>();
    private final TestInstanceFactory testInstanceFactory;

    public DynamicPointVer4(DynamicTestsHelperVer4 helper) {
        this.helper = Objects.requireNonNull(helper);
        this.testInstanceFactory = Objects.requireNonNull(helper.testInstanceFactory());
    }

    @Override
    public int version() {
        return 4;
    }

    @Override
    public DynamicTestsHelperVer4 helper() {
        return this.helper;
    }

    @Override
    public DynamicPointVer4 setNexus(Object nexus) {
        Objects.requireNonNull(nexus);
        if (this.nexus != nexus) {
            this.nexus = nexus;
            this.changed();
        }
        return this;
    }

    @Override
    public DynamicPointVer4 setParamTypes(Class<?> ... paramTypes) {
        Objects.requireNonNull(paramTypes, " param types must not be null");
        List<Class<?>> types = Arrays.asList(paramTypes);
        types.forEach(i -> Objects.requireNonNull(i, " param types must not contain null values " + types));
        if (!Objects.equals(this.paramTypes, types)) {
            this.paramTypes = types;
            this.changed();
        }
        return this;
    }

    @Override
    public DynamicPointVer4 addParams(Object ... param) {
        this.params.add(param);
        this.changed();
        return this;
    }

    @Override
    public DynamicPointVer4 addParamSet(Collection<Object[]> paramSet) {
        Objects.requireNonNull(paramSet);
        for (Object[] params : paramSet) {
            this.addParams(params);
        }
        return this;
    }

    @Override
    public DynamicPointVer4 addParamSet(Object[] ... paramSet) {
        Objects.requireNonNull(paramSet);
        for (Object[] params : paramSet) {
            this.addParams(params);
        }
        return this;
    }

    @Override
    public DynamicPointVer4 addDynamicTest(DynamicTest ... dynamicTest) {
        Objects.requireNonNull(dynamicTest);
        Arrays.asList(dynamicTest).forEach(Objects::requireNonNull);
        Stream.of(dynamicTest).forEach(t -> this.addedDynamicTests.add(this.testInstanceFactory.newDynamicTest(t.getDisplayName(), t.getExecutable())));
        return this;
    }

    @Override
    public DynamicPointVer4 addDynamicTest(String displayName, Executable executable) {
        this.testInstanceFactory.newDynamicTest(displayName, executable);
        return this.addDynamicTest(DynamicTest.dynamicTest((String)displayName, (Executable)executable));
    }

    @Override
    public DynamicPointVer4 nop() {
        return this;
    }

    @Override
    public DynamicPointVer4 checkTestCount(int expectedCount) {
        int actualSize = this.tests().size();
        Assertions.assertEquals((int)expectedCount, (int)this.tests().size(), () -> "expected test count " + expectedCount + " is not equal to actual test count " + actualSize);
        return this;
    }

    private void changed() {
        this.tests = null;
        this.helper().changed();
    }

    public String errorReport() {
        if (this.addedDynamicTests.size() == 0 & this.nexus == null) {
            return "nexus is not set";
        }
        if (this.addedDynamicTests.size() == 0 & this.paramTypes == null) {
            return "param types are not set";
        }
        int j = 0;
        if (this.paramTypes != null) {
            for (Object[] objects : this.params) {
                if (this.paramTypes.size() != objects.length) {
                    return "param types " + this.paramTypes + " do not correspond at param set no. " + j + Arrays.toString(objects);
                }
                ++j;
            }
        }
        return null;
    }

    public List<DynamicTest> tests() {
        if (this.tests == null) {
            String errorReport = this.errorReport();
            if (errorReport != null) {
                throw new DynamicTestFormationException(errorReport);
            }
            this.tests = this.generate();
        }
        return this.tests;
    }

    private List<DynamicTest> generate() {
        ArrayList<DynamicTest> dynamicTests = new ArrayList<DynamicTest>();
        if (this.nexus != null) {
            dynamicTests.addAll(DynamicTestUtils.generateAsList(this.nexus, this.params, this.paramTypes, this.testInstanceFactory));
        }
        dynamicTests.addAll(this.addedDynamicTests);
        return dynamicTests;
    }
}

