/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.org.junit5.extensions.dynamictests.impls.ver4;

import com.steammachine.org.junit5.extensions.dynamictests.DefaultTestFactory;
import com.steammachine.org.junit5.extensions.dynamictests.DynamicTestsHelper;
import com.steammachine.org.junit5.extensions.dynamictests.TestInstanceFactory;
import com.steammachine.org.junit5.extensions.dynamictests.impls.ver4.DynamicPointVer4;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;

public class DynamicTestsHelperVer4
implements DynamicTestsHelper {
    public static final int VERSION = 4;
    private List<DynamicPointVer4> points = new ArrayList<DynamicPointVer4>();
    private List<DynamicTest> dynamicTests;
    private final TestInstanceFactory testInstanceFactory;

    public DynamicTestsHelperVer4(TestInstanceFactory testInstanceFactory) {
        this.testInstanceFactory = Objects.requireNonNull(testInstanceFactory);
    }

    public DynamicTestsHelperVer4() {
        this.testInstanceFactory = DefaultTestFactory.DEFAULT_FACTORY;
    }

    @Override
    public DynamicPointVer4 addPoint() {
        DynamicPointVer4 point = new DynamicPointVer4(this);
        this.points.add(point);
        this.changed();
        return point;
    }

    @Override
    public DynamicTestsHelperVer4 nop() {
        return this;
    }

    @Override
    public DynamicTestsHelperVer4 check() {
        this.tests();
        return this;
    }

    public void changed() {
        this.dynamicTests = null;
    }

    @Override
    public DynamicTestsHelperVer4 checkTestCount(int expectedCount) {
        int actualSize = this.tests().size();
        Assertions.assertEquals((int)expectedCount, (int)this.tests().size(), () -> "expected test count " + expectedCount + " is not equal to actual test count " + actualSize);
        return this;
    }

    @Override
    public Stream<DynamicTest> stream() {
        return this.tests().stream();
    }

    @Override
    public Collection<DynamicTest> collection() {
        return this.tests();
    }

    @Override
    public Iterable<DynamicTest> iterable() {
        return this.tests();
    }

    @Override
    public Iterator<DynamicTest> iterator() {
        return this.tests().iterator();
    }

    @Override
    public int version() {
        return 4;
    }

    public TestInstanceFactory testInstanceFactory() {
        return this.testInstanceFactory;
    }

    private List<DynamicTest> tests() {
        if (this.dynamicTests != null) {
            return this.dynamicTests;
        }
        ArrayList<DynamicTest> generate = new ArrayList<DynamicTest>();
        for (DynamicPointVer4 point : this.points) {
            generate.addAll(point.tests());
        }
        this.dynamicTests = generate;
        return this.dynamicTests;
    }

    private static List<DynamicTest> reduceLists(List<DynamicTest> dt1, List<DynamicTest> dt2) {
        ArrayList<DynamicTest> list = new ArrayList<DynamicTest>();
        list.addAll(dt1);
        list.addAll(dt2);
        return list;
    }
}

