/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.org.junit5.extensions.dynamictests.methodcomparator;

import com.steammachine.org.junit5.extensions.dynamictests.methodcomparator.ClassMethodTable;
import com.steammachine.org.junit5.extensions.dynamictests.methodcomparator.MethodComparatorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;

class AsInSourceCodeMetodComparatorV3
implements MethodComparatorFactory {
    AsInSourceCodeMetodComparatorV3() {
    }

    @Override
    public Comparator<Method> methodComparator(Class<?> clazz) {
        return new IntrenalMethodComparator(clazz);
    }

    public String toString() {
        return "AsInSourceCodeMetodComparatorV3";
    }

    private static boolean isInheritor(Class classA, Class classB) {
        Objects.requireNonNull(classA, "classA is null");
        Objects.requireNonNull(classB, "classB is null");
        if (classA == classB) {
            return false;
        }
        return classB.isAssignableFrom(classA);
    }

    private static void checkClassesEqual(Class classA, Class classB) {
        if (Objects.requireNonNull(classA) != Objects.requireNonNull(classB)) {
            throw new IllegalStateException("classes  must be the same");
        }
    }

    public static Map<String, ClassMethodTable.SourceCodePosition> methodsMap(Class clazz) {
        Map<String, ClassMethodTable.SourceCodePosition> map;
        InputStream classStream = clazz.getResourceAsStream(clazz.getSimpleName() + ".class");
        if (classStream == null) {
            return Collections.emptyMap();
        }
        try {
            map = ClassMethodTable.readClassFromInputStream(classStream);
        }
        catch (Throwable throwable) {
            try {
                classStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        classStream.close();
        return map;
    }

    private static class IntrenalMethodComparator
    implements Comparator<Method> {
        private final Class<?> clazz;
        private final Map<String, ClassMethodTable.SourceCodePosition> map;

        private IntrenalMethodComparator(Class<?> clazz) {
            if (clazz == null) {
                throw new NullPointerException("clazz is null");
            }
            this.clazz = clazz;
            this.map = AsInSourceCodeMetodComparatorV3.methodsMap(clazz);
        }

        @Override
        public int compare(Method meth, Method meth2) {
            if (meth == meth2) {
                return 0;
            }
            if (AsInSourceCodeMetodComparatorV3.isInheritor(meth.getDeclaringClass(), meth2.getDeclaringClass())) {
                return -1;
            }
            if (AsInSourceCodeMetodComparatorV3.isInheritor(meth2.getDeclaringClass(), meth.getDeclaringClass())) {
                return 1;
            }
            AsInSourceCodeMetodComparatorV3.checkClassesEqual(meth.getDeclaringClass(), meth2.getDeclaringClass());
            AsInSourceCodeMetodComparatorV3.checkClassesEqual(this.clazz, meth2.getDeclaringClass());
            ClassMethodTable.SourceCodePosition pos = this.map.get(ClassMethodTable.methodSignature(meth));
            ClassMethodTable.SourceCodePosition pos2 = this.map.get(ClassMethodTable.methodSignature(meth2));
            if (pos == null && pos2 == null) {
                return 0;
            }
            if (pos != null && pos2 == null) {
                return 1;
            }
            if (pos == null && pos2 != null) {
                return -1;
            }
            if (!pos.hasPosition() && !pos2.hasPosition()) {
                return 0;
            }
            if (pos.hasPosition() && !pos2.hasPosition()) {
                return 1;
            }
            if (!pos.hasPosition() && pos2.hasPosition()) {
                return -1;
            }
            if (pos.lineNumber() == pos2.lineNumber()) {
                return pos.order() - pos2.order();
            }
            return pos.lineNumber() - pos2.lineNumber();
        }
    }
}

