/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.org.junit5.extensions.dynamictests.simpletestparam;

import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.Executable;

public class SimpleParam {
    private static final SimpleParam UNUSED = new SimpleParam(null, null, false);
    private final boolean used;
    private final String testName;
    private final Executable executable;

    public boolean used() {
        return this.used;
    }

    private SimpleParam(String testName, Executable executable, boolean used) {
        this.testName = testName;
        this.executable = executable;
        this.used = used;
    }

    public String testName() {
        return this.testName == null ? "" + this : this.testName;
    }

    private SimpleParam(String testName, Executable executable) {
        this(testName, executable, true);
    }

    public static SimpleParam simpleTest(String testName, Executable executable) {
        return new SimpleParam(testName, executable);
    }

    public SimpleParam ignore() {
        return SimpleParam.unused();
    }

    public static SimpleParam unused() {
        return UNUSED;
    }

    public static SimpleParam delimer(String data) {
        return SimpleParam.unused();
    }

    public static DynamicTest dynamicTest(SimpleParam p) {
        return DynamicTest.dynamicTest((String)p.testName, (Executable)p.executable);
    }

    public String toString() {
        return "SimpleParam{used=" + this.used + ", testName='" + this.testName + '\'' + ", executable=" + this.executable + '}';
    }
}

