package com.steammachine.propertyeditor.baseeditors;

import static com.steammachine.propertyeditor.types.EditorTags.Tag.VALUE_NULLABLE;

import com.steammachine.propertyeditor.types.EditorTags;
import com.steammachine.propertyeditor.types.Selection;

@EditorTags(include = VALUE_NULLABLE)
public class BooleanProperty extends DefaultPropertyEditor<Boolean> {

    public BooleanProperty(String name, Class<Boolean> type, Selection selection) {
        super(name, type, selection);
    }

    @Override
    public String getAt(int index) {
        Boolean valueAt = getValueAt(index);
        return valueAt != null ? "" + valueAt : null;
    }

    @Override
    public void set(String value) {
        setValue(value == null ? null : Boolean.valueOf(value));
    }
}
