package com.steammachine.propertyeditor.baseeditors;

import static com.steammachine.propertyeditor.types.EditorTags.Tag.READ_ONLY;
import static com.steammachine.propertyeditor.types.EditorTags.Tag.VALUE_NULLABLE;

import com.steammachine.propertyeditor.types.EditorTags;
import com.steammachine.propertyeditor.types.Selection;

@EditorTags(include = READ_ONLY, exclude = VALUE_NULLABLE)
public class ClassProperty extends DefaultPropertyEditor<Class> {

    public ClassProperty(String name, Class<Class> type, Selection selection) {
        super(name, type, selection);
    }

    @Override
    public String getAt(int index) {
        Class valueAt = getValueAt(index);
        return valueAt != null ? "" + valueAt.getName() : null;
    }

    @Override
    public void set(String value) {
    }
}
