package com.steammachine.propertyeditor.baseeditors;

import static java.util.function.Function.identity;
import static java.util.stream.Collectors.toList;
import static java.util.stream.Collectors.toMap;

import com.steammachine.propertyeditor.types.PropertyEditor;
import com.steammachine.propertyeditor.types.PropertyEditors;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DefaultPropertyEditors implements PropertyEditors {

    private final List<PropertyEditor> ordered;
    private final Map<String, PropertyEditor> properties;


    public DefaultPropertyEditors(List<PropertyEditor> editorsList) {
        ordered = editorsList.stream()
                .sorted(Comparator.comparing(PropertyEditor::propertyName))
                .collect(toList());
        properties = editorsList.stream().collect(toMap(PropertyEditor::propertyName, identity()));
    }

    @Override
    public Optional<PropertyEditor> findEditor(String propertyName) {
        return Optional.ofNullable(properties.get(propertyName));
    }

    public <T> Optional<PropertyEditor<T>> findEditor(String propertyName, Class<T> type) {
        //noinspection unchecked
        return findEditor(propertyName)
                .filter(editor -> editor.propertyType() == type)
                .map(editor -> (PropertyEditor<T>) editor);
    }

    public List<PropertyEditor> getEditors() {
        return ordered;
    }
}
