package com.steammachine.propertyeditor.baseeditors;

import static java.util.Arrays.*;

import com.steammachine.propertyeditor.types.Selection;
import java.util.function.Consumer;

public class EnumProperty extends DefaultPropertyEditor<Enum> {


    public EnumProperty(String name, Class<Enum> type, Selection selection) {
        super(name, type, selection);
    }

    @Override
    public String getAt(int index) {
        return getValueAt(index).name();
    }

    @Override
    public void set(String value) {
        //noinspection unchecked
        setValue(Enum.valueOf(propertyType(), value));
    }

    @Override
    public void getValues(Consumer<String> proc) {
        stream(propertyType().getEnumConstants()).map(Enum::name).forEachOrdered(proc);
    }
}
