package com.steammachine.propertyeditor.baseeditors;

import static com.steammachine.propertyeditor.types.EditorTags.Tag.VALUE_NULLABLE;

import com.steammachine.propertyeditor.types.EditorTags;
import com.steammachine.propertyeditor.types.Selection;

@EditorTags(include = VALUE_NULLABLE)
public class ShortProperty extends DefaultPropertyEditor<Short> {

    public ShortProperty(String name, Class<Short> type, Selection selection) {
        super(name, type, selection);
    }

    @Override
    public String getAt(int index) {
        Short valueAt = getValueAt(index);
        return valueAt != null ? "" + valueAt : null;
    }

    @Override
    public void set(String value) {
        setValue(value == null ? null : Short.valueOf(value));
    }
}
