package com.steammachine.propertyeditor.types;

import static java.util.Arrays.asList;
import static java.util.Objects.requireNonNull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DefaultSelection implements Selection {

    private final Collection<Object> objects;

    private DefaultSelection(Collection<Object> objects) {
        this.objects = requireNonNull(objects);
    }

    public static DefaultSelection selectionFormCollection(Collection<Object> objects) {
        return new DefaultSelection(objects);
    }

    public static DefaultSelection selectionFormObjects(Object object, Object... objects) {
        List<Object> items = new ArrayList<>();
        items.add(object);
        items.addAll(asList(objects));
        return selectionFormCollection(items);
    }

    @Override
    public Iterator<Object> iterator() {
        return objects.iterator();
    }

    @Override
    public long size() {
        return objects.size();
    }
}
