package com.steammachine.propertyeditor.types;

import java.util.function.Consumer;

public interface PropertyEditor<T> {

    String propertyName();

    String getAt(int index);

    void set(String value);

    void setValue(T value);

    T getValueAt(int index);

    Class<T> propertyType();

    boolean allEquals();

    default void getValues(Consumer<String> proc) {
    }

    boolean isReadOnly();

}
